import { userVariables } from 'testcafe';
import {
  getAdminUser,
  AppsPage,
  NodeRedPage,
  ServicesTabPage,
  StatusPage,
} from './webstatus.models';

fixture.skip(`Node-RED`).beforeEach(async (t) => {
  await t.useRole(
    getAdminUser(
      userVariables.targetUrl as string,
      userVariables.targetPassword as string,
    ),
  );
  // ignore native dialogs that might appear
  await t.setNativeDialogHandler(() => true);
});

test.skip('Enable and start Node-RED', async (t) => {
  // node-red button should not be visible because it is still disabled
  await t.expect(AppsPage.nodeRedButton.visible).eql(false);

  // got to Services tab
  await t.click(StatusPage.servicesTab);

  // node-red should be disabled at the beginning of this test
  await t.expect(ServicesTabPage.nodeRed.enabledRadioButton.checked).eql(false);
  await t.expect(ServicesTabPage.nodeRed.disabledRadioButton.checked).eql(true);

  // click the label of the "enable node-red" radio button
  await t.click(ServicesTabPage.nodeRed.enabledRadioButtonLabel);

  // save all
  await t.click(ServicesTabPage.saveAllButton);

  // go back to Apps tab
  await t.click(StatusPage.appsTab);

  await t.setNativeDialogHandler((...args) => {
    console.log('args', args);
  });

  // wait for node-red to start
  await t.wait(5000);
  // save the current url of webstatus
  const webstatusUrl: URL = new URL(await t.eval(() => document.documentURI));

  // click the node-red button to open a new window with the url to the node-red frontend
  await t.click(AppsPage.nodeRedButton);
  await t.wait(1000);

  // The test continues in the new window
  // Node-RED Editor should be visible
  await t.expect(NodeRedPage.editor.exists).eql(true);

  // get the url of the new window
  const nodeRedUrl: URL = new URL(await t.eval(() => document.documentURI));

  // node-red runs on the same host but on a different port
  await t.expect(nodeRedUrl.hostname).eql(webstatusUrl.hostname);
  await t.expect(nodeRedUrl.port).eql('41880');
});

test.skip('Disable Node-RED', async (t) => {
  // node-red button should be visible because previous test activated it
  await t.expect(AppsPage.nodeRedButton.visible).eql(true);

  await t.click(StatusPage.servicesTab);

  // node-red should be enabled by previous test
  await t.expect(ServicesTabPage.nodeRed.enabledRadioButton.checked).eql(true);
  await t
    .expect(ServicesTabPage.nodeRed.disabledRadioButton.checked)
    .eql(false);

  // click the label of the "enable node-red" radio button
  await t.click(ServicesTabPage.nodeRed.disabledRadioButtonLabel);

  // save all
  await t.click(ServicesTabPage.saveAllButton);

  // go back to Apps tab
  await t.click(StatusPage.appsTab);

  // node-red button should not be visible anymore
  await t.expect(AppsPage.nodeRedButton.visible).eql(false);
});
