#!/bin/bash
set -e

IMAGE=${1:-development}

echo "Starting webstatus-$IMAGE container ..."

ROOT_DIR=$(git rev-parse --show-toplevel)

# Assign webstatus directory if not already set
if [ -z "$WEBSTATUS_DIR" ]; then
	WEBSTATUS_DIR=$(realpath "$ROOT_DIR"/src/revpi)
fi

# Assign pictory directory if not already set
if [ -z "$PICTORY_DIR" ]; then
	PICTORY_DIR=$(realpath "$ROOT_DIR"/../pictory/src/pictory)
fi

# Also mount test folder if running testcafe
TESTS_VOLUME=""
if [ "$IMAGE" == 'testcafe' ]; then
	TESTS_VOLUME="-v ./testcafe/tests:/opt/testcafe/tests"
fi

PERSISTENT_DATA=''
# Uncomment next line to use persistent pictory data on docker host
# PERSISTENT_DATA='-v /var/www/revpi/pictory/projects'



echo "Mounting webstatus from $WEBSTATUS_DIR"
echo "Mounting pictory from $PICTORY_DIR"

docker run \
	--rm \
	-p 42080:80 \
	-p 41080:41080 \
	-p 42443:443 \
	-p 41443:41443 \
	-v "$WEBSTATUS_DIR":/var/www/revpi \
	-v "$PICTORY_DIR":/var/www/revpi/pictory \
	-v /var/www/revpi/data \
	$PERSISTENT_DATA \
	$TESTS_VOLUME \
	--name webstatus-"$IMAGE" \
	registry.gitlab.com/revolutionpi/webstatus/webstatus-"$IMAGE"-bullseye:arm64-latest
