#!/bin/bash
set -e

######
# Starts webstatus with the current local webstatus sources
######

ROOT_DIR=$(git rev-parse --show-toplevel)
WEBSTATUS_DIR=$(realpath "$ROOT_DIR"/src/revpi)

echo "Starting webstatus-development container ..."
echo "Mounting webstatus from $WEBSTATUS_DIR"

docker run \
	-it \
	--rm \
	-p 42080:80 \
	-p 41080:41080 \
	-p 42443:443 \
	-p 41443:41443 \
	-v "$WEBSTATUS_DIR":/var/www/revpi \
	-v /var/www/revpi/data \
	--name webstatus-development \
	registry.gitlab.com/revolutionpi/webstatus/webstatus-development-bullseye:arm64-latest
