# Testing webstatus
To test webstatus on your local machine
you need to build the docker container and start it with the provided script
(detailed steps below)

Then you can access webstatus at   
https://0.0.0.0:41443

Login with

> User: admin   
> Password: raspberry

> **NOTE:** This is only meant for testing simple things in the PHP Code 
> or in the website.
> 
> Anything that needs an actual device will not work!

# Building and publishing Docker images

> **NOTE:**
The images do not have to be updated for every change or new version of webstatus or pictory as the current sources
will be mounted into the container when it is started.

## Base Docker image
To update the base docker image for webstatus you need the correct credentials for publishing to the RevolutionPi Container Registry on GitLab.
Set the credentials to the correct environment variables and run this script:

```shell
# Current working dir should be test/docker/ or change the paths to the Dockerfile and build context accordingly
$ cd test/docker/
$ ../docker-publish.sh development ./Dockerfile
```

## E2E Docker image

**This image is also used in pictory E2E tests**

To update the Docker image for the E2E tests run this:

```shell
# Current working dir should be test/testcafe/ or change the paths to the Dockerfile and build context accordingly
$ cd test/testcafe/
$ ../docker-publish.sh testcafe ./Dockerfile
# alternatively run via npm
$ npm docker:publish
```

# Run webstatus in Docker container 

To start a container with webstatus locally simply run
```shell
$ test/docker-dev.sh
```

As long as this script is running, webstatus is available at https://0.0.0.0:41443

The local state of webstatus sources will be mounted in the container.
This means:

1. Your local changes to the source code will be immediately available in the webstatus instance running in the container
 

# End-to-end Tests with Testcafe
The most important use cases of webstatus are covered by E2E tests implemented with [Testcafe](https://testcafe.io/)

To run these tests against a local webstatus development instance use
```shell
$ npm run test
```

These tests will be **automatically** executed in the Gitlab CI

# Tests with HTTP Client Requests
Multiple Test Cases are implemented in test/http-requests/*.http files which can be executed with the [IntelliJ HTTP Client](https://www.jetbrains.com/help/idea/http-client-in-product-code-editor.html)

To get a session for testing, always execute test/login.http first.
This will set a global session for every other request executed within the same IntelliJ instance.

These tests will **NOT** be executed automatically. You must run them by hand on you local setup. 
