var swtDebug = false;
var currentLang = "en";
var cookieExpireMinutes = 30;

// global variables, available in jQuery ready and external functions!
var saveEMail = "";
var userData = "";
var saveUUID = "";

$(function() {
	$("#noscriptContents").hide();
	$("#scriptContents").show();

	saveUUID = checkSession();
	if (saveUUID != "") {
		if ($.urlParam('cp') == 'true') {
			// special mode: allow -Change Password- when called from 'status'-page
			// do nothing here since handlers are not yet established; process at the end of jQuery $(function() ...
		} else {
			// if already logged in, don't stay on index but jump to status
			window.location.href = "status.html";
			return;
		}
	}

	$("#loginCurrentDateTime").html(getDateTime("##DD##.##MM##.##YYYY## ##HH##:##NN##:##SS##"));
	$("#registerCurrentDateTime").html(getDateTime("##DD##.##MM##.##YYYY## ##HH##:##NN##:##SS##"));

	// base declares

	userData = ajaxGetUserData("","##REMOVE_RESET_PW##");

	// show / hide on start
	$("#panelLogin").show();
	$("#panelLoginMsgHeader").hide();
	$("#spnLoginNewPW").hide();
	$("#spnLoginConfirmNewPW").hide();
	$("#spnLoginRemoveResetPW").hide();
	$("#buttSaveChangePW").hide();
	//$("#panelMisc").hide(); not used
	$("#linkLoginBackLogin").hide();
	if (userData.data.removeResetPW == true) {
			$("#linkLoginResetPW").hide();
	}

	// re-set initial subtitle
	$("#subtitle").html("RevPi Login");

	// set intial focus
	$( "#hiddenfigures" ).focus();

	$("#linkTest").on('click', function(event) {
		event.preventDefault();
		ajaxTest();
	});

	// check code update and show warning
	var infoTextHTML = 	"<span style='color:#ff0000'>-RevPi- web applications have been updated since last usage<br><strong>PLEASE CLEAR YOUR BROWSER CACHE!</strong></span>" +
						"<br>&nbsp;<br>" +
						"<span style='font-size:small'>Find more detailed info about cache clearing here:<br>" +
						"<a href='https://en.wikipedia.org/wiki/Wikipedia:Bypass_your_cache' target='_blank'>https://en.wikipedia.org/wiki/Wikipedia:Bypass_your_cache</a></span>";

	var objWebstatusConfig = AjaxGetJSON("../config.json", "OBJ");
	$("#lblVersion").html(objWebstatusConfig.version); // show version number next to copyright
	$("#lblCYear").html(objWebstatusConfig.c_year); // show year of copyright
	var hlpCookieLastWebstatusVersion = Cookies.get('KUNBUS_RevPiLastWebstatusVersion');

	// PiCtory version checking ONLY when -PiCtory- package is installed!
	if (fileExists("../pictory/config.json")) {
		var objPiCtoryConfig = AjaxGetJSON("../pictory/config.json", "OBJ");
		var hlpCookieLastPiCtoryVersion = Cookies.get('KUNBUS_RevPiLastPiCtoryVersion');
		if (
			((typeof hlpCookieLastWebstatusVersion != "undefined") && (hlpCookieLastWebstatusVersion != objWebstatusConfig.version)) ||
			((typeof hlpCookieLastPiCtoryVersion != "undefined") && (hlpCookieLastPiCtoryVersion != objPiCtoryConfig.version))
			) {
			createInfoDialog("Important",infoTextHTML, '{"width":700, "height":300}');
		}

		// write new version to cookie
		Cookies.set('KUNBUS_RevPiLastPiCtoryVersion', objPiCtoryConfig.version,{expires: new Date('2038-01-19T04:14:07')});
	}

	Cookies.set('KUNBUS_RevPiLastWebstatusVersion', objWebstatusConfig.version,{expires: new Date('2038-01-19T04:14:07')});

	// event handlers

	$("#linkLoginBackLogin").on('click', function(event) {
		window.location.href = index.html;
	});

	$("#linkLoginChangePW").on('click', function(event) {
		event.preventDefault();

		$("#spnLoginNewPW").show();
		$("#spnLoginConfirmNewPW").show();

		if (userData.data.removeResetPW == false) {
			$("#spnLoginRemoveResetPW").show();
		}

		if ($.urlParam('cp') == 'true') {
			// special mode: allow -Change Password- when called from 'status'-page
			$("#linkLoginBackStatus").show();
			$("#linkLoginBackLogin").hide();
		} else {
			$("#linkLoginBackLogin").show();
		}

		$("#buttSaveChangePW").show();
		$("#buttLogin").hide();
		$("#buttLogin").hide();
		$("#linkLoginChangePW").hide();
		$("#hiddenfigures").focus();

		$("#subtitle").html("RevPi Change Password");

	});

	$("#linkLoginResetPW").on('click', function(event) {
		event.preventDefault();

		var checkResult = "";
		checkResult = checkUserPW(
			$.trim($("#inpLoginEMail").val()),
			"",
			"",
			"",
			"RESETPW"
		);

		if (checkResult != "") {
			if (checkResult.indexOf('ERR_USER_EMPTY') > -1) {
				$("#msgLoginEMail").html('please enter Username!');
			}
			if (checkResult.indexOf('ERR_USER_INVALID') > -1) {
				$("#msgLoginEMail").html('Username invalid!');
			}
		} else {
				if( confirm("Passwort will be resetted - please confirm!") == false ){
					return;
				}

				var retAjax = ajaxResetPW($("#inpLoginEMail").val());
				if (retAjax.status == "SUCCESS") {
					$("#panelLoginMsgHeader").html("Password has been reset ...");
					$("#panelLoginMsgHeader").show();
				}
				else {
					$("#panelLoginMsgHeader").html(GetErrorText(retAjax.status, currentLang, "long"));
					$("#panelLoginMsgHeader").show();
				}
		}
	});

	$("#buttSaveChangePW").on('click', function(event) {
		event.preventDefault();

		$("#panelLoginMsgHeader").hide();
		$("#msgLoginEMail").html('');
		$("#msgLoginPW").html('');
		$("#msgLoginCaptcha").html('');
		$("#msgLoginNewPW").html('');
		$("#msgLoginConfirmNewPW").html('');

		var checkResult = "";
		checkResult = checkUserPW(
			$.trim($("#inpLoginEMail").val()),
			$.trim($("#inpLoginPW").val()),
			$.trim($("#inpLoginConfirmNewPW").val()),
			$.trim($("#inpLoginNewPW").val()),
			"SAVECHANGEPW"
		);

		if (checkResult != "") {
			if (checkResult.indexOf('ERR_USER_EMPTY') > -1) {
				$("#msgLoginEMail").html('please enter Username!');
			}
			if (checkResult.indexOf('ERR_USER_INVALID') > -1) {
				$("#msgLoginEMail").html('Username invalid!');
			}
			if (checkResult.indexOf('ERR_PW_INVALID') > -1) {
				$("#msgLoginPW").html('please enter valid password (min 8 characters, numbers and letters only!)');
			}
			if (checkResult.indexOf('ERR_NEWPW_INVALID') > -1) {
				$("#msgLoginNewPW").html('please enter valid NEW password (min 8 characters, numbers and letters only!)');
			}
			if (checkResult.indexOf('ERR_PWCONFIRM_NOMATCH') > -1) {
				$("#msgLoginConfirmNewPW").html("new password and confirmation don't match!");
			}
		} else {
				var retAjax = ajaxChangePW($("#inpLoginEMail").val(),$("#inpLoginPW").val(),$("#inpLoginNewPW").val(), $('#chkRemoveResetPW').prop('checked'));
				if (retAjax.status == "SUCCESS") {
					$("#panelLoginMsgHeader").html("Password has been changed ...");
					$("#panelLoginMsgHeader").show();
					$("#buttSaveChangePW").hide();
					$("#buttLogin").show();
					$("#spnLoginNewPW").hide();
					$("#spnLoginConfirmNewPW").hide();
					$("#spnLoginRemoveResetPW").hide();
					$("#inpLoginPW").val('');
					// we hide the -Reset Password to Default- link if we disabled the option!
					if ($('#chkRemoveResetPW').prop('checked') == true) {
						$("#linkLoginResetPW").hide();
					}
				}
				else {
					$("#panelLoginMsgHeader").html(GetErrorText(retAjax.status, currentLang, "long"));
					$("#panelLoginMsgHeader").show();
				}
		}
	});


	$("#buttLogin").on('click', function(event) {
		event.preventDefault();

		// reset
		$("#panelLoginMsgHeader").hide();
		$("#msgLoginEMail").html('');
		$("#msgLoginPW").html('');
		$("#spnLoginNewPW").hide();
		$("#buttSaveChangePW").hide();
		$("#buttLogin").show();

		var checkResult = "";
		checkResult = checkUserPW(
			$.trim($("#inpLoginEMail").val()),
			$.trim($("#inpLoginPW").val()),
			"",
			"",
			"LOGIN"
		);

		if (checkResult != "") {
			if (checkResult.indexOf('ERR_USER_EMPTY') > -1) {
				$("#msgLoginEMail").html('please enter Username!');
			}
			if (checkResult.indexOf('ERR_USER_INVALID') > -1) {
				$("#msgLoginEMail").html('Username invalid!');
			}
			if (checkResult.indexOf('ERR_PW_INVALID') > -1) {
				$("#msgLoginPW").html('please enter valid passwort (min 8 characters, numbers and letters only!)');
			}
		} else {
			// actual login!
			var retAjax = ajaxLogin($("#inpLoginEMail").val(),$("#inpLoginPW").val());
			if (retAjax.status == "SUCCESS") {
				var cookieExpire = new Date(new Date().getTime() + cookieExpireMinutes * 60 * 1000);
				Cookies.set('KUNBUS_RevPiUser_' + retAjax.data.uuid, $("#inpLoginEMail").val(),{expires: cookieExpire});
				Cookies.set('KUNBUS_RevPiSessionId_' + retAjax.data.uuid, retAjax.data.sessionId,{expires: cookieExpire});
				window.location.href = "status.html";
			}
			else {
				$("#panelLoginMsgHeader").html(GetErrorText(retAjax.status, currentLang, "long"));
				$("#panelLoginMsgHeader").show();
			}
		}
	});

	/* Submits on Enter */
	$("#inpLoginEMail, #inpLoginPW, #inpLoginNewPW").keyup(function(event){
		if(event.keyCode == 13){
			if ($("#inpLoginNewPW").is(":visible")) {
				$("#buttSaveChangePW").click();
			} else {
				$("#buttLogin").click();
			}
		}
	});

	/* process Change Password special mode when called from status page */
	if ($.urlParam('cp') == 'true') {
		// special mode: allow -Change Password- when called from 'status'-page
		$("#linkLoginChangePW").trigger( "click" );
	}

});

// Internal functions
function refreshDelegates() {
	$("#linkToLogin").on('click', function(event) {
		event.preventDefault();
		$("#panelRegister").hide();
		$("#panelLogin").show();
		if (saveEMail != "") {
			$("#inpLoginEMail").val(saveEMail);
		}
	});
}

function checkUserPW(user, pw, pwConfirm, pwNew, mode) {

	var checkResult = "";

	if(user == "") {
		checkResult += "ERR_USER_EMPTY" + "|";
	}

	// don't check PW on PW reset request! :-)
	if (mode != "RESETPW") {
		if((pw.length < 6) || (isAlpha(pw) == false)) {
			checkResult += "ERR_PW_INVALID" + "|";
		}
	}

	if (mode == "SAVECHANGEPW") {
		if ((pwNew.length < 8) || (isAlpha(pwNew) == false)) {
			checkResult += "ERR_NEWPW_INVALID" + "|";
		}
		if (pwNew != pwConfirm) {
			checkResult += "ERR_PWCONFIRM_NOMATCH" + "|";
		}
	}

	return checkResult;

}
