// inp TS format: yyyy-mm-dd hh:nn:ss
function formatTimestamp(inpTS, formatType) {
	var retString = inpTS;

	if (formatType == "DE") {
		retString = inpTS.substr(8,2);
		retString = retString + "." + inpTS.substr(5,2);
		retString = retString + "." + inpTS.substr(0,4);
		retString = retString + " " + inpTS.substr(11,2);
		retString = retString + ":" + inpTS.substr(14,2);
		retString = retString + ":" + inpTS.substr(17,2);
	}

	return retString;
}

function fileExists(url) {

	var ret = false;

	// if global variable is defined, use it as request type
	// if not, use GET request since this MUST work
	var requestType = "GET";
	if (typeof(fileExistsRequestMethod) != "undefined") {
		requestType = fileExistsRequestMethod;
	}

	$.ajax({
		url:url,
		type:requestType,
		async: false,
		error: function()
		{
			ret = false;
		},
		success: function()
		{
			ret = true;
		}
	});

	return ret;
}

function pad(n, width, z) {
	z = z || '0';
	n = n + '';
	if (isNaN(width)) {
		return "";
	}
	return n.length >= width ? n : new Array(width - n.length + 1).join(z) + n;
}

function validateEmail(email) {
    var re = /^(([^<>()\[\]\\.,;:\s@"]+(\.[^<>()\[\]\\.,;:\s@"]+)*)|(".+"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}])|(([a-zA-Z\-0-9]+\.)+[a-zA-Z]{2,}))$/;
    return re.test(email);
}

function isAlpha(inputtxt)
{
	var letterNumber = /^[0-9a-zA-Z]+$/;
	if(inputtxt.match(letterNumber)) {
		return true;
	} else {
		return false;
	}
}

function isHex(h) {
var a = parseInt(h,16);
return (a.toString(16) === h)
}

/*
*	IMPORTANT: Hash function copied from -realperson- plugin
*	ToDo: put the compare of captcha hash an input has on server!
*/
function rpHash(value) {
		var hash = 5381;
		for (var i = 0; i < value.length; i++) {
			hash = ((hash << 5) + hash) + value.charCodeAt(i);
		}
		return hash;
}

function getDateTime(replPattern) {
	var ret = replPattern;
	var d = new Date();

	ret = ret.replace("##DD##",pad(d.getDate(),2));
	ret = ret.replace("##MM##",pad(d.getMonth()+1,2));
	ret = ret.replace("##YYYY##",d.getFullYear());
	ret = ret.replace("##HH##",pad(d.getHours(),2));
	ret = ret.replace("##NN##",pad(d.getMinutes(),2));
	ret = ret.replace("##SS##",pad(d.getSeconds(),2));

	return ret;
}


function GetErrorText(idErrorText, lang, size) {

	var retHtml = "";
	var hlpErrorsJSON = AjaxGetJSON("misc/errors.json", "OBJ");
	if (typeof(hlpErrorsJSON.errors[0][lang][idErrorText]) != "undefined") {
		retHtml = hlpErrorsJSON.errors[0][lang][idErrorText][size];
		var link = hlpErrorsJSON.errors[0][lang][idErrorText]["link"];
		if (typeof(link) != "undefined") {
			retHtml += " - <a target='_blank' href='" + link + "'>click for support</a>";
		}
		return retHtml;
	}
	else {
		return "UNKNOWN ERROR:" + idErrorText ;
	}
}

function AjaxGetJSON(parPathname, mode) {

	var hlpPathname = parPathname;
	var retJSON = "";

	$.ajax({
		url : hlpPathname + "?_=" + Date(),
		type : "get",
		async: false,
		dataType: "text",
		success : function(data) {
			// remove CR/LF
			// this allows string literals to have CR/LF content for better readability
			data = data.replace(/(\r\n|\n|\r)/gm,"");
			data = data.replace(/\t+/g, "");
			if (mode == "OBJ") {
				retJSON = JSON.parse(data);
			}
			else {
				// return JSON as String
				retJSON = data;
			}
		},
		error: function(jqXHR, textStatus, errorThrown) {
		   alert( "Error in AjaxGetJSON: " + errorThrown );
		}
	});

	if (retJSON != "") {
		return retJSON;
	}
	else {
		return "ERR_NO_DATA";
	}
}

function checkSession() {

	var retAjax = ajaxGetDeviceData("##UUID##");
	if (retAjax.data.replPattern != "##UUID##") {
		var retAjaxCheckToken = ajaxCheckToken();
		if (retAjaxCheckToken.status == "SUCCESS") {
			return retAjax.data.replPattern;
		} else {
			return "";
		}
	} else {
		return "";
	}

}

function refreshLoginCookies(expireMin, uuid) {
	if(""+Cookies.get('KUNBUS_RevPiUser_' + uuid) !== "undefined") {
		var cookieExpire = new Date(new Date().getTime() + expireMin * 60 * 1000);
		Cookies.set('KUNBUS_RevPiUser_' + uuid, Cookies.get('KUNBUS_RevPiUser_' + uuid),{expires: cookieExpire});
		Cookies.set('KUNBUS_RevPiSessionId_' + uuid, Cookies.get('KUNBUS_RevPiSessionId_' + uuid),{expires: cookieExpire});
	}
}

function openInNewTab(url) {
  var win = window.open(url, '_blank');
  win.focus();
}

function openNewUrl(url) {
  var win = window.open(url, '_self');
  win.focus();
}

function killLastDelimiter(inpString,delimiter) {
        var retString = $.trim(inpString);
        if(retString != "") {
                if (retString.substr(retString.length - delimiter.length, delimiter.length) == delimiter) {
                        retString = retString.substr(0, retString.length - delimiter.length);
                }
        }
        return retString;
}

function AjaxResetDriver(uuid) {

	// IMPORTANT: call resetDriver.php function of PiCtory!

	var hlpRet = "";
	var JSONdata = "{'RevPiSessionId': '" + Cookies.get('KUNBUS_RevPiSessionId_' + uuid) +"'}";
	JSONdata = JSONdata.replace(/'/g, '"');

	$.ajax({
		async: false,
		url: "pictory/php/resetDriver.php",
		type : 'POST',
		data: JSONdata,
		processData: false,
		dataType: 'text',
		contentType: 'application/json; charset=utf-8',
		success: function(response) {
			hlpRet = response;
		}
	});

}

function createInfoDialog(mode,infotext, options) {

	var hlpMode = (mode == "") ? "Info" : mode;
	var titleText;
	var titleColor;

	if (hlpMode == "Info") {
		titleText = hlpMode;
		titleColor = "#000000";
	}
	if ((hlpMode == "Error") || (hlpMode == "Important")) {
		titleText = hlpMode;
		titleColor = "#ff6600";
	}

	var hlpOptions = JSON.parse('{}');
	if (options != "") {
		hlpOptions = JSON.parse(options);
	}

	$("#dialog_info").dialog({
		height: hlpOptions.hasOwnProperty('height') == true ? hlpOptions.height : 200,
		width: hlpOptions.hasOwnProperty('width') == true ? hlpOptions.width : 400,
		modal: hlpOptions.hasOwnProperty('modal') == true ? hlpOptions.modal : true,
		resizable: hlpOptions.hasOwnProperty('resizable') == true ? hlpOptions.resizable : false,
		title: hlpOptions.hasOwnProperty('title') == true ? hlpOptions.title : titleText,
		show: { effect: "blind", duration: 200 },
		create: function (event, ui) {
				$('.ui-dialog').css('background', '#ff0000 important!');
		},
		buttons : {
			Ok: function() {
				$(this).dialog("close");
			}
		},
		open: function(event, ui){
			$("#lblDialogInfo").html(infotext);
			if (hlpOptions.hasOwnProperty('autoClose')) {
				$("#dialog_info").dialog("option", "buttons", {}); // remove OK button when autoClose
				setTimeout("$('#dialog_info').dialog('close')",hlpOptions.autoClose);
			}
		}
	}).prev(".ui-dialog-titlebar").css("background",titleColor);

	$(".ui-dialog-titlebar-close").hide(); // hide close x icon

}


// jquery extensions
// returns
// 1. value of parameter if both exist
// 2. null if parameter doesn't exist
// 3. "" if paramter exists but has no value set
$.urlParam = function(name){
	var results = new RegExp('[\?&]' + name + '=([^&#]*)').exec(window.location.href);
	if (results != null) {
		return results[1] || "";
	} else {
		return null;
	}
}
