# Revolution Pi revpi-make-sll-cert

This script is designed to generate self-signed TLS (Transport Layer Security) certificates for encrypting sensitive information during transmission. TLS certificates are essential for ensuring secure communication and preventing unauthorized access to data transmitted over the network.

The self-signed TLS certificate is used in conjunction with the Apache server to enable secure communication over the internet by encrypting data transmitted between the server and clients. Apache needs to be configured with the appropriate self-signed TLS certificate to establish secure connections.

## Usage

### Install dependencies
```
sudo apt install python3-openssl
```

### Run script
```
sudo ./revpi-cert-wizard [-h] [-n] [-t] [-f]
```
```
usage: revpi-cert-wizard [-h] [-n] [-t] [-f]
```
### Output
```
$ sudo ./revpi-cert-wizard -h
usage: revpi-cert-wizard [-h] [-n] [-t] [-f]

This script is designed to generate self-signed TLS (Transport Layer Security) certificates for encrypting
sensitive information during transmission. TLS certificates are essential for ensuring secure
communication and preventing unauthorized access to data transmitted over the network.

optional arguments:
  -h, --help   show this help message and exit
  -n, --name   create TLS-Certificate only when hostname not correct
  -t, --time   create TLS-Certificate only when date is expired
  -f, --force  create new TLS-Certificate overwriting any existing certificate

Default behaviour: no arguments. Check if certificate and key exist and if not, create the
certificate and key.
```
