<!--
SPDX-FileCopyrightText: 2024 KUNBUS GmbH

SPDX-License-Identifier: GPL-2.0-or-later
-->

# Revolution Pi webserver configurations

This repository will contain the basic configurations for the Revolution Pi for
various web servers. These configurations can be extended via packages that also
require web server support.

## Document root

The folder `/usr/share/revpi-webserver/www` represents the document root for all
web server variants, which is integrated into the site configurations. This
folder can be extended by other RevPi software if they also install a
configuration for the access permissions in `conf` folder.

## Extend configuration

The following two folders are used by other RevPi software to make their web
server use possible. These folders are defined as "trigger" in the Debian
package and trigger a reload of the web server when changed. With this
technique, no further web server integrations of other software packages have to
be carried out.

In general, a distinction is made between the paths
`/usr/share/revpi-webserver/${webserver_name}/conf` and
`/usr/share/revpi-webserver/${webserver_name}/sites`. In the further text,
abbreviated by `conf` and `sites`. Below are the respective paths of the web
servers.

Web server configurations in the `conf` folder extend the virtual host with port
number 41443 that this package brings with it. All configurations must be able
to be loaded validly within a virtual host.

Web server configurations that create a new virtual host must be stored in
the `sites` folder. These are automatically loaded by the revpi-webserver
configuration and are immediately active in the web server.

### Apache

All software packages with the extension -apache place their configuration
extensions in these folders.

- /usr/share/revpi-webserver/apache2/conf
- /usr/share/revpi-webserver/apache2/sites
