import { Selector } from 'testcafe';
import { AddDeviceBase, DeviceIds } from '../pictory/pictory.models';

fixture`export_pictory_rsc_format`;

test('Export PiCtory rsc format', async (t) => {
  await AddDeviceBase(DeviceIds.Core3);

  // Set dialog handler BEFORE any t actions
  await t.setNativeDialogHandler(() => true);

  const fileMenu = Selector('#file');
  const exportMenu = Selector('#file_export');
  const exportRadio = Selector('#rdoExport');
  const exportModeShow = Selector('#rdoExportModeShow');
  const exportOkBtn = Selector('span').withText('Ok');
  const exportTextArea = Selector('#taShowExport');

  // Ensure export flow works step by step
  await t
    .hover(fileMenu).expect(fileMenu.visible).ok('File menu not visible')
    .click(exportMenu).expect(exportMenu.exists).ok('Export menu not available')
    .click(exportRadio).expect(exportRadio.checked).ok('Export radio not selected')
    .expect(Selector('#tblExportData b').withText('PiCtory project file').exists)
    .ok('Export table label not found')
    .expect(Selector('#tblExportData b').withText('PiCtory project file').textContent)
    .eql('PiCtory project file', 'Export table label text mismatch')
    .click(exportModeShow)
    .expect(exportModeShow.checked).ok('Export mode "Show" should be selected')
    .click(exportOkBtn.with({ visibilityCheck: true, timeout: 3000 }), { speed: 0.75 });

  // Wait for the export result to be populated
  await t.expect(async () => {
    const content = await exportTextArea.textContent;
    return content && content.trim().length > 0;
  }).ok('Export result is empty after clicking OK', { timeout: 5000 });

  const text = await exportTextArea.textContent;

  await t
    .expect(text).contains('{"App":{"name": "PiCtory", "version": ', 'Missing export header')
    .expect(text).contains('"type": "BASE","productType": "95","position": "0","name": ', 'Missing base device block');
});
