var rapEdit = function (deviceId) {
  this.deviceId = deviceId;
  this.objRAPfile = '';

  this.createDialog();
  //this.showDialog();
  //this.refreshDelegates();

  //alert(deviceId);
};

rapEdit.prototype.createDialog = function () {
  var me = this;

  console.log('createDialog');

  $('#dialog_editRAP').empty();
  $('#dialog_editRAP').append(
    $('<div>').load('rapEdit.html', function () {
      debugger;
      me.objRAPfile = AjaxGetJSON('resources/data/rap/' + me.deviceId + '.rap', 'OBJ');
      if (typeof me.objRAPfile.input.variants != 'undefined' || typeof me.objRAPfile.output.variants != 'undefined') {
        me.showSelectVariantDialog();
      } else {
        me.showDialog('');
        me.refreshDelegates();
      }
    }),
  );
};

rapEdit.prototype.showSelectVariantDialog = function () {
  var me = this;

  var cntInpVar = typeof me.objRAPfile.input.variants != 'undefined' ? me.objRAPfile.input.variants.length : 0;
  var cntOutVar = typeof me.objRAPfile.output.variants != 'undefined' ? me.objRAPfile.output.variants.length : 0;
  var arrSync = [];

  if (typeof me.objRAPfile.rules != 'undefined' && typeof me.objRAPfile.rules.IO != 'undefined') {
    $.each(me.objRAPfile.rules.IO, function (ioIndex, ioEntry) {
      arrSync.push(ioEntry.sync);
    });
  } else {
    arrSync.push('no_sync'); // no sync rules
  }

  $('#tbl_selectVariant tbody').find('tr:gt(0)').remove(); // clear appended rows from previews dialog rendering

  // Case 01: we have Input AND Output variants
  if (cntInpVar > 0 && cntOutVar > 0) {
    for (var inp = 0; inp < cntInpVar; inp++) {
      for (var out = 0; out < cntOutVar; out++) {
        $.each(arrSync, function (syncIndex, syncEntry) {
          if (arrSync[0] == 'no_sync' || (inp == syncEntry[0] && out == syncEntry[1])) {
            $('#tbl_selectVariant tbody').append($('#tmpl_row_selectVariant').clone());
            $('#tbl_selectVariant tr:last').attr('id', 'row_selectVariant_' + inp + '_' + out);
            var hlpHTML = $('#' + 'row_selectVariant_' + inp + '_' + out).html();
            hlpHTML = hlpHTML.replace(/##INP_VARIANT_ID##/g, me.objRAPfile.input.variants[inp].id);
            hlpHTML = hlpHTML.replace(/##OUT_VARIANT_ID##/g, me.objRAPfile.input.variants[out].id);
            hlpHTML = hlpHTML.replace(/##INP_VARIANT_INDEX##/g, inp);
            hlpHTML = hlpHTML.replace(/##OUT_VARIANT_INDEX##/g, out);
            $('#' + 'row_selectVariant_' + inp + '_' + out).html(hlpHTML);
            $('#' + 'row_selectVariant_' + inp + '_' + out).show();
          }
        });
      }
    }
  } else {
    var cntVar = cntInpVar > 0 ? cntInpVar : cntOutVar;
    for (var i = 0; i < cntVar; i++) {
      $('#tbl_selectVariant tbody').append($('#tmpl_row_selectVariant').clone());
      $('#tbl_selectVariant tr:last').attr(
        'id',
        'row_selectVariant_' + (cntInpVar > 0 ? i : 0) + '_' + (cntOutVar > 0 ? i : 0),
      );
      var hlpHTML = $('#' + 'row_selectVariant_' + (cntInpVar > 0 ? i : 0) + '_' + (cntOutVar > 0 ? i : 0)).html();

      if (cntInpVar > 0) {
        hlpHTML = hlpHTML.replace(/##INP_VARIANT_ID##/g, me.objRAPfile.input.variants[i].id);
        hlpHTML = hlpHTML.replace(/##OUT_VARIANT_ID##/g, '-');
        hlpHTML = hlpHTML.replace(/##INP_VARIANT_INDEX##/g, i);
        hlpHTML = hlpHTML.replace(/##OUT_VARIANT_INDEX##/g, 'x');
      } else {
        hlpHTML = hlpHTML.replace(/##OUT_VARIANT_ID##/g, me.objRAPfile.output.variants[i].id);
        hlpHTML = hlpHTML.replace(/##INP_VARIANT_ID##/g, '-');
        hlpHTML = hlpHTML.replace(/##OUT_VARIANT_INDEX##/g, i);
        hlpHTML = hlpHTML.replace(/##INP_VARIANT_INDEX##/g, 'x');
      }

      $('#' + 'row_selectVariant_' + (cntInpVar > 0 ? i : 0) + '_' + (cntOutVar > 0 ? i : 0)).html(hlpHTML);
      $('#' + 'row_selectVariant_' + (cntInpVar > 0 ? i : 0) + '_' + (cntOutVar > 0 ? i : 0)).show();
    }
  }

  $('#dialog_selectVariant').dialog({
    width: 400,
    height: 300,
    modal: true,
    resizable: false,
    title: 'Select Variant',
    show: { effect: 'blind', duration: 200 },
    buttons: [
      {
        text: 'Ok',
        icons: {
          primary: 'ui-icon-heart',
        },
        click: function () {
          me.showDialog($('input:radio[name=rdo_selectVariant]:checked').attr('id'));
          $(this).dialog('close');
        },
      },
    ],
  });
};

rapEdit.prototype.showDialog = function (selectedVariant) {
  var me = this;
  //console.log("showDialog");

  $('#dialog_editRAP').dialog({
    width: 1024,
    height: 650,
    modal: true,
    resizable: false,
    title: 'RAP Editor',
    show: { effect: 'blind', duration: 200 },
    buttons: [
      {
        text: 'Ok',
        icons: {
          primary: 'ui-icon-heart',
        },
        click: function () {
          $(this).dialog('close');
        },
      },
    ],
  });

  $('#dialog_editRAP').dialog('option', 'title', 'RAP Editor - Device: ' + me.deviceId);
};

rapEdit.prototype.refreshDelegates = function () {
  var me = this;
  console.log('refreshDelegates');
};

rapEdit.prototype.validate = function () {
  var me = this;
};
