// Optional global config object for customization
window.pictory = window.pictory ?? {};

$.ajaxSetup({
  data: { RevPiSessionId: Cookies.get('KUNBUS_RevPiSessionId_' + getURLParameter('hn')) },
});
// STRING functions

function pad(n, width, z) {
  z = z || '0';
  n = n + '';
  if (isNaN(width)) {
    return '';
  }
  return n.length >= width ? n : new Array(width - n.length + 1).join(z) + n;
}

// FILE functions

function fileExists(url) {
  var ret = false;

  // if global variable is defined, use it as request type
  // if not, use GET request since this MUST work
  var requestType = 'GET';
  if (typeof fileExistsRequestMethod != 'undefined') {
    requestType = fileExistsRequestMethod;
  }

  $.ajax({
    url: url,
    type: requestType,
    async: false,
    error: function () {
      ret = false;
    },
    success: function () {
      ret = true;
    },
  });

  return ret;
}

function AjaxDeleteFile(pathname) {
  var hlpRet = '';
  var JSONdata =
    "{'pathname': " + pathname + ",'RevPiSessionId': '" + Cookies.get('KUNBUS_RevPiSessionId_' + revPiHostname) + "'}";
  JSONdata = JSONdata.replace(/'/g, '"');

  $.ajax({
    async: false,
    url: 'php/deleteFile.php',
    type: 'POST',
    data: JSONdata,
    processData: false,
    dataType: 'text',
    contentType: 'application/json; charset=utf-8',
    success: function (response) {
      hlpRet = response;
      if (hlpRet == 'PHP_SESSION_INVALID') {
        // if no valid server session can be found, remove client cookies also
        Cookies.remove('KUNBUS_RevPiUser_' + revPiHostname);
        Cookies.remove('KUNBUS_RevPiSessionId_' + revPiHostname);
        createInfoDialog('Timeout', '<br>' + 'Session expired ...', '');
      }
    },
  });
}

function AjaxRenameFile(mode) {
  var hlpRet = '';
  var JSONdata =
    "{'mode': " + mode + ",'RevPiSessionId': '" + Cookies.get('KUNBUS_RevPiSessionId_' + revPiHostname) + "'}";
  JSONdata = JSONdata.replace(/'/g, '"');

  $.ajax({
    async: false,
    cache: false,
    url: 'php/renameFile.php',
    type: 'POST',
    data: JSONdata,
    processData: false,
    dataType: 'text',
    contentType: 'application/json; charset=utf-8',
    success: function (response) {
      hlpRet = response;
      if (hlpRet == 'PHP_SESSION_INVALID') {
        // if no valid server session can be found, remove client cookies also
        Cookies.remove('KUNBUS_RevPiUser_' + revPiHostname);
        Cookies.remove('KUNBUS_RevPiSessionId_' + revPiHostname);
        createInfoDialog('Timeout', '<br>' + 'Session expired ...', '');
      }
    },
  });
}

function AjaxResetDriver(dummy) {
  var hlpRet = '';

  var JSONdata = "{'RevPiSessionId': '" + Cookies.get('KUNBUS_RevPiSessionId_' + revPiHostname) + "'}";
  JSONdata = JSONdata.replace(/'/g, '"');

  $.ajax({
    async: false,
    url: 'php/resetDriver.php',
    type: 'POST',
    data: JSONdata,
    processData: false,
    dataType: 'text',
    contentType: 'application/json; charset=utf-8',
    success: function (response) {
      hlpRet = response;
      if (hlpRet == 'PHP_SESSION_INVALID') {
        // if no valid server session can be found, remove client cookies also
        Cookies.remove('KUNBUS_RevPiUser_' + revPiHostname);
        Cookies.remove('KUNBUS_RevPiSessionId_' + revPiHostname);
        createInfoDialog('Timeout', '<br>' + 'Session expired ...', '');
      } else {
        if (hlpRet != 0) {
          createInfoDialog('Error', '<br>' + 'Unable to reset driver ...', '');
        }
      }
    },
  });

  //alert(hlpRet);
}

function AjaxRunActions(reset, start, showResponse) {
  var hlpRet = '';
  var JSONdata = '{##RESET##,##START##,##REVPISESSIONID##}';

  // handle parameters; param. which are -false- will NOT be given over to PHP script at all
  if (reset == true) {
    JSONdata = JSONdata.replace('##RESET##', "'reset':true");
  } else {
    JSONdata = JSONdata.replace('##RESET##', "'reset':false");
  }

  if (start == true) {
    JSONdata = JSONdata.replace('##START##', "'start':true");
  } else {
    JSONdata = JSONdata.replace('##START##', "'start':false");
  }

  JSONdata = JSONdata.replace(
    '##REVPISESSIONID##',
    "'RevPiSessionId':'" + Cookies.get('KUNBUS_RevPiSessionId_' + revPiHostname) + "'",
  );
  JSONdata = JSONdata.replace(/'/g, '"');

  $.ajax({
    async: false,
    url: 'php/runActions.php',
    type: 'POST',
    data: JSONdata,
    processData: false,
    dataType: 'text',
    contentType: 'application/json; charset=utf-8',
    success: function (response) {
      hlpRet = response;
      if (hlpRet == 'PHP_SESSION_INVALID') {
        // if no valid server session can be found, remove client cookies also
        Cookies.remove('KUNBUS_RevPiUser_' + revPiHostname);
        Cookies.remove('KUNBUS_RevPiSessionId_' + revPiHostname);
        createInfoDialog('Timeout', '<br>' + 'Session expired ...', '');
      }
    },
  });

  if (showResponse == true) {
    if (hlpRet == 'OK') {
      createInfoDialog('', '<br>Success ...', '{"autoClose":1000}');
    } else {
      createInfoDialog('', '<br>ERROR:' + hlpRet, '{}');
    }
  }
}

// CONTROL handling functions
function setSelectByValue(eID, val) {
  //Loop through sequentially//
  var ele = document.getElementById(eID);
  for (var ii = 0; ii < ele.length; ii++) {
    if (ele.options[ii].value == val) {
      //Found!
      ele.options[ii].selected = true;
      return true;
    }
  }

  return false;
}

function setSelectByText(eID, text) {
  //Loop through sequentially//
  var ele = document.getElementById(eID);
  for (var ii = 0; ii < ele.length; ii++) {
    if (ele.options[ii].text == text) {
      //Found!
      ele.options[ii].selected = true;
      return true;
    }
  }

  return false;
}

function setSelectByIndex(eId, index) {
  $('#' + eId).prop('selectedIndex', index);
  return true;
}

// DATA ACCESS LAYER

function AjaxGetJSON(parPathname, mode) {
  //console.log("CACHE: " + Cookies.get('KUNBUS_PiCtory_Cache'));

  var hlpPathname = parPathname;
  var retJSON = '';
  var useCache = true;

  //exclude special files from alerting when file not exists OR is empty (like _config.rsc on first start)
  var arrFilesNoAlert = ['php/getProjectFile.php?fn=_config.rsc'];
  var shouldLogError = $.inArray(parPathname, arrFilesNoAlert) == -1;
  // exclude certain file types from caching ...
  // explicitly exclude _userSettings.json to force change of Settings/Cache mode
  if (parPathname.toLowerCase().indexOf('.rsc') > -1 || parPathname.toLowerCase().indexOf('_usersettings.json') > -1) {
    useCache = false;
  } else {
    // suspend caching when Cache-Cookie is set (e.g. on reload via menu)
    if (typeof Cookies.get('KUNBUS_PiCtory_Cache') != 'undefined') {
      hlpPathname = hlpPathname + '?_=' + Cookies.get('KUNBUS_PiCtory_Cache');
    } else {
      // set caching according to user settings
      if (userSettingsData != '') {
        if (userSettingsData.hasOwnProperty('03')) {
          useCache = userSettingsData['03'].mode == 0 ? true : false;
        }
      }
    }
  }

  $.ajax({
    url: hlpPathname,
    type: 'get',
    async: false,
    cache: useCache,
    dataType: 'text',
    beforeSend: function (xhr) {
      /* prevents - not well formed XML - warning in Firefox browsers */
      if (xhr.overrideMimeType) {
        xhr.overrideMimeType('application/json');
      }
    },
    success: function (data) {
      // remove CR/LF
      // this allows string literals to have CR/LF content for better readability
      data = data.replace(/(\r\n|\n|\r)/gm, '');
      data = data.replace(/\t+/g, '');
      if (mode == 'OBJ') {
        try {
          retJSON = JSON.parse(data);
        } catch (e) {
          retJSON = '';
        }
      } else {
        // return JSON as String
        retJSON = data;
      }
    },
    error: function (jqXHR, textStatus, errorThrown) {
      if (shouldLogError) {
        alert('Error in AjaxGetJSON: ' + errorThrown);
      }
    },
  });

  if (retJSON !== '') {
    return retJSON;
  } else {
    if (shouldLogError) {
      alert(parPathname + ': required JSON file not available or invalid!');
    }
    return 'ERR_NO_DATA';
  }
}

function GetJSONData(mode, pathname, selector) {
  var jsonDataObj;

  if (mode == 'DATATYPES') {
  }

  if (mode == 'CATALOG') {
    jsonDataObj = AjaxGetJSON(pathname != '' ? pathname : 'resources/data/catalog.json', 'OBJ');
    if (fileExists(configData.paths['catalog-custom'])) {
      jsonDataObj = appendCatalogCustom(jsonDataObj);
    }
    var resultObj = JSONSelect.match(selector, jsonDataObj);
  }

  if (mode == 'GSD') {
    jsonDataObj = AjaxGetJSON(pathname, 'OBJ');
    var resultObj = JSONSelect.match(selector, jsonDataObj);
  }

  return resultObj;
}

// MISC functions
//
//
function sortJSON(objJSON, prop) {
  var retJSON = objJSON;
  return _.sortBy(retJSON, prop);
}

function killLastDelimiter(inpString, delimiter) {
  var retString = $.trim(inpString);
  if (retString != '') {
    if (retString.substr(retString.length - delimiter.length, delimiter.length) == delimiter) {
      retString = retString.substr(0, retString.length - delimiter.length);
    }
  }
  return retString;
}

function getPosDelimiter(inpString, delimiter, delPos) {
  var retPos = -1;
  var cntDelimiters = delPos;
  var arrPosDelimiters = [];
  var posDelimiter = inpString.indexOf(delimiter);
  while (posDelimiter > -1) {
    arrPosDelimiters.push(posDelimiter);
    posDelimiter = inpString.indexOf(delimiter, posDelimiter + 1);
  }

  if (arrPosDelimiters.length > 0) {
    if (isNaN(delPos)) {
      // special delPos
      if (delPos == 'FIRST') {
        retPos = arrPosDelimiters[0];
      }
      if (delPos == 'LAST') {
        retPos = arrPosDelimiters[arrPosDelimiters.length - 1];
      }
    } else {
      // numeric delPos
      if (delPos <= arrPosDelimiters.length) {
        retPos = arrPosDelimiters[delPos - 1];
      }
    }
  }

  return retPos;
}

function getCountAvailableHosts(strNetmask) {
  var allBits = '';
  var arrIPparts = strNetmask.split('.');
  $.each(arrIPparts, function (index, IPpart) {
    allBits = allBits + pad(parseInt(IPpart).toString(2), 8);
  });

  return Math.pow(2, (allBits.match(/0/g) || []).length) - 2; // subtract 2 since 0 and 255 are not allowed
}

function createConfirmDialog(mode) {
  $('#dialog_confirm').dialog({
    width: 550,
    modal: true,
    show: { effect: 'blind', duration: 400 },
    buttons: [
      {
        text: 'Ok',
        icons: {
          primary: 'ui-icon-heart',
        },
        click: function () {
          $(this).dialog('close');
          confirmResult = true; // declared in main.js
          processConfirm();
        },
      },
      {
        text: 'Cancel',
        icons: {
          primary: 'ui-icon-closethick',
        },
        click: function () {
          $(this).dialog('close');
          confirmResult = false; // declared in main.js
          processConfirm();
        },
      },
    ],
  });

  if (mode == 'CLEAR' || mode == 'OPEN_PROJECT') {
    $('#lblConfirmMessage').html('Data of current project will be lost!');
  }

  if (mode == 'EXIT') {
    $('#lblConfirmMessage').html('Project has unsaved changes!');
  }

  if (mode == 'RESET_DATA') {
    $('#lblConfirmMessage').html('Data of device will be lost!');
  }
}

function createExtendedDataDialog(productType) {
  $('#dialog_extendedData_' + productType).dialog({
    width: 1024,
    height: 610,
    modal: true,
    resizable: false,
    title: 'Extended Data',
    show: { effect: 'blind', duration: 200 },
    buttons: [
      {
        text: 'Ok',
        icons: {
          primary: 'ui-icon-heart',
        },
        click: function () {
          $(this).dialog('close');
        },
      },
    ],
  });

  $('.ui-dialog-titlebar-close').hide(); // hide close x icon
}

function createInfoDialog(mode, infotext, options) {
  var hlpMode = mode == '' ? 'Info' : mode;
  var titleText;
  var titleColor;

  if (hlpMode == 'Info') {
    titleText = hlpMode;
    titleColor = '#000000';
  }
  if (hlpMode == 'Error' || hlpMode == 'Timeout') {
    titleText = hlpMode;
    titleColor = window.pictory.primaryColor ?? '#ff6600';
  }

  var hlpOptions = JSON.parse('{}');
  if (options != '') {
    hlpOptions = JSON.parse(options);
  }

  $('#dialog_info')
    .dialog({
      height: hlpOptions.hasOwnProperty('height') == true ? hlpOptions.height : 200,
      width: hlpOptions.hasOwnProperty('width') == true ? hlpOptions.width : 400,
      modal: hlpOptions.hasOwnProperty('modal') == true ? hlpOptions.modal : true,
      resizable: hlpOptions.hasOwnProperty('resizable') == true ? hlpOptions.resizable : false,
      title: hlpOptions.hasOwnProperty('title') == true ? hlpOptions.title : titleText,
      show: { effect: 'blind', duration: 200 },
      buttons: {
        Ok: function () {
          $(this).dialog('close');
          if (hlpMode == 'Timeout') {
            // return to login page
            window.location.href = window.isSSOHost ? 'php/logout.php' : configData.paths.login;
          }
        },
      },
      open: function (event, ui) {
        $('#lblDialogInfo').html(infotext);
        if (hlpOptions.hasOwnProperty('autoClose')) {
          $('#dialog_info').dialog('option', 'buttons', {}); // remove OK button when autoClose
          setTimeout("$('#dialog_info').dialog('close')", hlpOptions.autoClose);
        }
      },
    })
    .prev('.ui-dialog-titlebar')
    .css('background', titleColor);
}

function createConnectionDialog(mode) {
  $('#dialog_manageConnections').dialog({
    width: 1024,
    height: 650,
    modal: true,
    resizable: false,
    title: 'Manage Connections',
    show: { effect: 'blind', duration: 200 },
    buttons: [
      {
        text: 'Ok',
        icons: {
          primary: 'ui-icon-heart',
        },
        click: function () {
          $(this).dialog('close');
        },
      },
    ],
  });

  $('.ui-dialog-titlebar-close').hide(); // hide close x icon
}

function createEditRAPDialog(deviceId) {
  $('#dialog_editRAP').dialog({
    width: 1024,
    height: 650,
    modal: true,
    resizable: false,
    title: 'RAP Editor',
    show: { effect: 'blind', duration: 200 },
    buttons: [
      {
        text: 'Ok',
        icons: {
          primary: 'ui-icon-heart',
        },
        click: function () {
          $(this).dialog('close');
        },
      },
    ],
  });

  fillEditRAPDialog(deviceId);
}

function fillEditRAPDialog(deviceId) {
  $('#dialog_editRAP').dialog('option', 'title', 'RAP Editor - Device: ' + deviceId);
}

function createUserSettingsDialog() {
  $('#dialog_userSettings').dialog({
    width: Math.min(1024, window.innerWidth),
    height: Math.min(768, window.innerHeight),
    modal: true,
    resizable: false,
    title: 'User Settings',
    show: { effect: 'blind', duration: 200 },
    buttons: [
      {
        text: 'Save',
        icons: {
          primary: 'ui-icon-heart',
        },
        click: function () {
          var hasErrors = false;
          var errMessage = '';
          var errControl = '';
          // validate before saving
          $('#dialog_userSettings_msg').hide();

          // setting 01 - Session Timeout
          if ($('#userSetting_01_min').val() == '' || $('#userSetting_01_min').val() == 0) {
            hasErrors = true;
            errMessage = 'ERR: Please enter valid -Custom timeout- (1-999)';
            errControl = 'userSetting_01_min';
          }

          // setting 02 - Auto Export
          $("[id^='userSetting_02_expFilenameWithoutSuffix_']").each(function (index) {
            var posLastDelim = getPosDelimiter($(this).attr('id'), '_', 'LAST');
            var hlpFile = $(this)
              .attr('id')
              .substr(posLastDelim + 1);
            $(this).val($.trim($(this).val())); // trim
            if ($('#userSetting_02_chkExport_' + hlpFile).is(':checked') && $(this).val() == '') {
              hasErrors = true;
              errMessage = 'ERR: Export Filename must not be empty for active export';
              errControl = $(this).attr('id');
            }

            if ($(this).val().indexOf('.') > -1) {
              hasErrors = true;
              errMessage = 'ERR: Please enter filename without suffix (suffix is set by export config)!';
              errControl = $(this).attr('id');
            }

            if ($(this).val().indexOf(' ') > -1) {
              hasErrors = true;
              errMessage = 'ERR: No Blanks allowed in filename ...';
              errControl = $(this).attr('id');
            }
          });

          // setting 03 - Cache
          // currently no validation necessary

          if (hasErrors == true) {
            $('#dialog_userSettings_msg').html(errMessage);
            $('#dialog_userSettings_msg').show();
            $('#' + errControl).focus();
          } else {
            // SAVE

            // check if Timeout Settings have been changed and show info that PiCtory restart is needed!
            if (
              $('#userSetting_01_mode_hid').val() != $('#userSetting_01_mode').val() ||
              $('#userSetting_01_min_hid').val() != $('#userSetting_01_min').val()
            ) {
              createInfoDialog('Info', '<br>' + 'Please restart -PiCtory- for new timeout-settings to take effect', '');
            }

            // setting 01 - Session Timeout
            userSettingsData['01'][2] = $('#userSetting_01_mode').val();
            userSettingsData['01'][3] = $('#userSetting_01_min').val();

            // setting 02 - Auto Export
            userSettingsData['02'].mode = $('#userSetting_02_mode').val();
            if ($('#userSetting_02_mode').val() == 1) {
              userSettingsData['02'].set = []; // clear set array;
              $("[id^='userSetting_02_expJSONfilename_']").each(function (index) {
                var hlpCheckState;
                if ($('#userSetting_02_chkExport_' + $(this).html().replace('.json', '')).is(':checked')) {
                  hlpCheckState = true;
                } else {
                  hlpCheckState = false;
                }

                userSettingsData['02'].set.push([
                  $(this).html(),
                  $('#userSetting_02_expFilenameWithoutSuffix_' + $(this).html().replace('.json', '')).val(),
                  hlpCheckState,
                ]);
              });
            }

            // setting 03 - Cache
            if (userSettingsData.hasOwnProperty('03')) {
              userSettingsData['03'].mode = $('#userSetting_03_mode').val();
            } else {
              // if cache setting does not exist yet, we create it ...
              var hlpJSONObj = {};
              hlpJSONObj.mode = $('#userSetting_03_mode').val();
              userSettingsData['03'] = hlpJSONObj;
            }

            // setting 04 - Autosave
            if (userSettingsData.hasOwnProperty('04')) {
              userSettingsData['04'][2] = $('#userSetting_04_mode').val();
              userSettingsData['04'][3] = $('#userSetting_04_min').val();
            } else {
              // if autosave setting does not exist yet, we create it ...
              var hlpJSONObj = ['Autosave', false, '', ''];
              hlpJSONObj[2] = $('#userSetting_04_mode').val();
              hlpJSONObj[3] = $('#userSetting_04_min').val();
              userSettingsData['04'] = hlpJSONObj;
            }

            // check if Autosave Settings have been changed and if so clear timer and restart autosave interval
            // IMPORTANT: this is done HERE so we can use -getAutosaveMin- function which relies on userSettingsData
            if (
              $('#userSetting_04_mode_hid').val() != $('#userSetting_04_mode').val() ||
              $('#userSetting_04_min_hid').val() != $('#userSetting_04_min').val()
            ) {
              var hlpAutosaveMin = getAutosaveMin();
              window.clearInterval(timerAutoSave); // clear interval
              if (hlpAutosaveMin != 0) {
                // switch on interval if not set to off
                timerAutoSave = setInterval(function () {
                  doAutoSave();
                }, hlpAutosaveMin * 60000); // min --> milliseconds
              }
            }

            $.ajax({
              async: false,
              url:
                'php/saveProject.php?fn=_tmp_userSettings.json' +
                '&RevPiSessionId=' +
                Cookies.get('KUNBUS_RevPiSessionId_' + revPiHostname),
              type: 'POST',
              data: JSON.stringify(userSettingsData),
              processData: false,
              dataType: 'text',
              contentType: 'application/json; charset=utf-8',
              success: function (response) {
                hlpRet = response;
                if (hlpRet == 'PHP_SESSION_INVALID') {
                  // if no valid server session can be found, remove client cookies also
                  Cookies.remove('KUNBUS_RevPiUser_' + revPiHostname);
                  Cookies.remove('KUNBUS_RevPiSessionId_' + revPiHostname);
                  createInfoDialog('Timeout', '<br>' + 'Session expired ...', '');
                }
              },
            });

            AjaxRenameFile("'" + 'USER_SETTINGS' + "'");

            $(this).dialog('close');
          }
        },
      },
      {
        text: 'Cancel',
        icons: {
          primary: 'ui-icon-closethick',
        },
        click: function () {
          $(this).dialog('close');
        },
      },
    ],
  });

  // masking
  $('#userSetting_01_min').mask('000');

  // set dialog events
  //
  // session timeout
  $('#userSetting_01_mode').off();
  $('#userSetting_01_mode').on('change', function (e) {
    $('#dialog_userSettings_msg').hide();
    var currentVal = $('#' + $(this).attr('id')).val();
    if (currentVal == '2') {
      $('#userSetting_01_min').prop('disabled', false);
      $('#userSetting_01_min').focus();
    } else {
      $('#userSetting_01_min').prop('disabled', true);
    }
  });

  // Auto Export
  $('#userSetting_02_mode').off();
  $('#userSetting_02_mode').on('change', function (e) {
    $('#dialog_userSettings_msg').hide();
    var currentVal = $('#' + $(this).attr('id')).val();
    fillUserSettingsDialog(2);
  });

  // Autosave
  $('#userSetting_04_mode').off();
  $('#userSetting_04_mode').on('change', function (e) {
    $('#dialog_userSettings_msg').hide();
    var currentVal = $('#' + $(this).attr('id')).val();
    if (currentVal == '2') {
      $('#userSetting_04_min').prop('disabled', false);
      $('#userSetting_04_min').focus();
    } else {
      $('#userSetting_04_min').prop('disabled', true);
    }
  });

  // fill settings data into dialog controls
  //
  fillUserSettingsDialog(''); // fill all settings

  $('.ui-dialog-titlebar-close').hide(); // hide close x icon
}

function fillUserSettingsDialog(settingsNumber) {
  if (userSettingsData == '') {
    return; // no user settings
  }

  // 01a - Session Timeout
  if (settingsNumber == 1 || settingsNumber == '') {
    $('#userSetting_01_mode').val(userSettingsData['01'][2].toString());
    $('#userSetting_01_mode').trigger('change'); // enable/disable input field according to mode
    $('#userSetting_01_min').val(userSettingsData['01'][3]);
    $('#userSetting_01_mode_opt_std').html(
      $('#userSetting_01_mode_opt_std')
        .html()
        .replace('##CONFIG_TIMEOUT##', configData.misc.sessionExpireMin + ' min.'),
    );

    // set in invisible controls also to detect when settings have changed ...
    $('#userSetting_01_mode_hid').val(userSettingsData['01'][2].toString());
    $('#userSetting_01_min_hid').val(userSettingsData['01'][3]);
  }

  // 01b - Autosave
  if (settingsNumber == 4 || settingsNumber == '') {
    // autosave area may not be present in older versions of PiCtory
    if ('04' in userSettingsData) {
      $('#userSetting_04_mode').val(userSettingsData['04'][2].toString());
      $('#userSetting_04_mode').trigger('change'); // enable/disable input field according to mode
      $('#userSetting_04_min').val(userSettingsData['04'][3]);
      $('#userSetting_04_mode_opt_std').html(
        $('#userSetting_04_mode_opt_std')
          .html()
          .replace('##CONFIG_AUTOSAVE##', CONST_DEFAULT_MINUTES_AUTOSAVE.toString() + ' min.'),
      );

      // set in invisible controls also to detect when settings have changed ...
      $('#userSetting_04_mode_hid').val(userSettingsData['04'][2].toString());
      $('#userSetting_04_min_hid').val(userSettingsData['04'][3]);
    } else {
      // no autosave data in settings yet ... look into global config.json
      if (configData.misc.autoSave == 0 || configData.misc.autoSave == false) {
        // autosave was 0 (minutes) in first versions of PiCtory; was changed to switch 0/1 (meaning 0=false, 1=true) later
        // autosave minutes must now be set in User Settings dialog!
        $('#userSetting_04_mode').val('0');
      } else {
        // autosave was set in global config.json (other than 0) but will be ignored here an set to standard
        $('#userSetting_04_mode').val('1');
      }

      $('#userSetting_04_mode').trigger('change'); // enable/disable input field according to mode

      // Standard autosave interval: CONST_DEFAULT_MINUTES_AUTOSAVE
      $('#userSetting_04_min').val(CONST_DEFAULT_MINUTES_AUTOSAVE.toString());
      $('#userSetting_04_mode_opt_std').html(
        $('#userSetting_04_mode_opt_std')
          .html()
          .replace('##CONFIG_AUTOSAVE##', CONST_DEFAULT_MINUTES_AUTOSAVE.toString() + ' min.'),
      );
    }
  }

  // 02 - Auto Export
  if (settingsNumber == 2 || settingsNumber == '') {
    // 2017/11 - is now being globaly loaded on startup
    //var exportData = AjaxGetJSON(configData.paths.export + "config.json", "OBJ");
    //exportData.files = sortJSON(exportData.files, "order");

    // initialize mode from settings-file when showing dialog!
    if (settingsNumber == '') {
      $('#userSetting_02_mode').val(userSettingsData['02'].mode);
    }

    var arrAutoExportDefault = [];
    var arrAutoExportFilenameNoSuffix = [];
    var arrAutoExportActive = [];
    if ($('#userSetting_02_mode').val() == '0') {
      // use standard settings from global config.json
      if ($.isArray(configData.misc.autoExportDefault)) {
        arrAutoExportDefault = configData.misc.autoExportDefault;
        arrAutoExportFilenameNoSuffix = configData.misc.autoExportFilenameNoSuffix;
      } else {
        arrAutoExportDefault.push(configData.misc.autoExportDefault);
        arrAutoExportFilenameNoSuffix.push(configData.misc.autoExportFilenameNoSuffix);
      }
    } else {
      // use user settings from projects/_userSettings.json
      $.each(userSettingsData['02'].set, function (index, set) {
        arrAutoExportDefault.push(set[0]);
        arrAutoExportFilenameNoSuffix.push(set[1]);
        arrAutoExportActive.push(set[2]);
      });
    }

    var rowTemplate =
      '<tr>' +
      '<td><b>##SCREENNAME##</b></td>' +
      '<td>##DESCRIPTION##</td>' +
      "<td id='userSetting_02_expJSONfilename_##VALUE##'>##FILENAME##</td>" +
      "<td><input type='text' id='userSetting_02_expFilenameWithoutSuffix_##VALUE##' size='15' maxlength='15' value='##VALUE_EXPORTFN_NOSUFFIX##'></td>" +
      "<td align='center'><input type='checkbox' id='userSetting_02_chkExport_##VALUE##' value='##VALUE##' ##DEFAULT##></td>" +
      '</tr>';
    var rowTemplateWork = '';

    $('#tblSettingsExportData tbody').empty();
    $.each(exportData.files, function () {
      if (this.active == true) {
        rowTemplateWork = rowTemplate;
        rowTemplateWork = rowTemplateWork.replace('##SCREENNAME##', this.screenname);
        rowTemplateWork = rowTemplateWork.replace('##DESCRIPTION##', this.description);
        rowTemplateWork = rowTemplateWork.replace('##FILENAME##', this.filename);
        rowTemplateWork = rowTemplateWork.replace(/##VALUE##/g, this.filename.replace('.json', ''));

        if (fileExists('resources/data/patterns/export/' + this.filename)) {
          rowTemplateWork = rowTemplateWork.replace('##MISSING##', '');
        } else {
          rowTemplateWork = rowTemplateWork.replace('##MISSING##', '(FILE MISSING!)');
        }

        var hlpIsInArray = $.inArray(this.filename, arrAutoExportDefault);
        if (hlpIsInArray != -1) {
          if ($('#userSetting_02_mode').val() == 0) {
            rowTemplateWork = rowTemplateWork.replace('##DEFAULT##', 'checked');
          } else {
            if (arrAutoExportActive[hlpIsInArray] == true) {
              rowTemplateWork = rowTemplateWork.replace('##DEFAULT##', 'checked');
            } else {
              rowTemplateWork = rowTemplateWork.replace('##DEFAULT##', '');
            }
          }
          rowTemplateWork = rowTemplateWork.replace(
            '##VALUE_EXPORTFN_NOSUFFIX##',
            arrAutoExportFilenameNoSuffix[hlpIsInArray],
          );
        } else {
          rowTemplateWork = rowTemplateWork.replace('##DEFAULT##', '');
          rowTemplateWork = rowTemplateWork.replace('##VALUE_EXPORTFN_NOSUFFIX##', '');
        }

        // append row to table
        $('#tblSettingsExportData tbody').append(rowTemplateWork);
      }
    });

    //$("#userSetting_02_mode").val(userSettingsData["02"].mode);
    if ($('#userSetting_02_mode').val() == '0') {
      $('#userSettings_02_title01').html('Standard settings:');
      $("[id^='userSetting_02_expFilenameWithoutSuffix_']").prop('disabled', true);
      $("[id^='userSetting_02_chkExport_']").prop('disabled', true);
    } else {
      $('#userSettings_02_title01').html('Custom settings:');
      $("[id^='userSetting_02_expFilenameWithoutSuffix_']").prop('disabled', false);
      $("[id^='userSetting_02_chkExport_']").prop('disabled', false);
    }
  }

  // 03 - Cache
  if (settingsNumber == 3 || settingsNumber == '') {
    // IMPORTANT: 	cache setting was added without updating
    //				_usersettings.json file - so this property may not exist
    //				the first time we open the settings dialog after update
    //				If setting does NOT exist yet we do nothing - cache mode
    //				select defaults to '0' (On) in this case
    if (userSettingsData.hasOwnProperty('03')) {
      $('#userSetting_03_mode').val(userSettingsData['03'].mode);
    }
  }
}

function createProjectDialog(mode) {
  $('#dialog_project').dialog({
    width: 550,
    modal: true,
    title: mode == 'OPEN' ? 'Open Project' : 'Save Project',
    show: { effect: 'blind', duration: 200 },
    buttons: [
      {
        text: 'Ok',
        id: 'okDialogSaveProject',
        icons: {
          primary: 'ui-icon-heart',
        },
        click: function () {
          $('#txtInputFilename').val($.trim($('#txtInputFilename').val()));

          if (
            $('#txtInputFilename').val().indexOf('[') > -1 ||
            $('#txtInputFilename').val().indexOf(']') > -1 ||
            $('#txtInputFilename').val().indexOf(' ') > -1
          ) {
            $('#lblSaveProjectMessage').html('filename has invalid characters ...');
            return;
          }

          if ($('#txtInputFilename').val().substr(0, 1) == '_') {
            $('#lblSaveProjectMessage').html("filename must not start with '_'");
            return;
          }

          if (!fileExists(configData.paths.projects + $('#txtInputFilename').val() + '.rsc')) {
            currentExportTS = getCurrentTS('YmdHis');
            var retDoExport = doExport('project.json', $.trim($('#txtInputFilename').val()) + '.rsc');
            if (retDoExport != 'OK') {
              $('#lblSaveProjectMessage').html(retDoExport);
            } else {
              // do autoExport
              if (typeof configData.misc.autoExport != 'undefined' && configData.misc.autoExport == true) {
                var arrAutoExportDefault = [];
                var arrAutoExportFilenameNoSuffix = [];
                var arrGetActiveAutoExport = getActiveAutoExport();
                arrAutoExportDefault = arrGetActiveAutoExport[0];
                arrAutoExportFilenameNoSuffix = arrGetActiveAutoExport[1];

                $.each(arrAutoExportDefault, function (index, filename) {
                  var exportConfigData = getExportConfigData(filename);
                  var retDoExport = doExport(
                    filename,
                    '../export/' + arrAutoExportFilenameNoSuffix[index] + '.' + exportConfigData.filetype,
                    true,
                    false,
                  );
                });
              }

              setProjectInfo(
                $('#txtInputFilename').val(),
                getProjectFileLastSaved($('#txtInputFilename').val(), 'd.m.Y H:i:s'),
              );
              currentProjectFilename = $('#txtInputFilename').val();
              $(this).dialog('close');
              swtIsDirty = false;

              createInfoDialog('Info', '<br>Project saved...', '{"autoClose":1000}');
            }
          } else {
            $('#lblSaveProjectMessage').html(
              'project ' + $('#txtInputFilename').val() + ' already exists - use override button to replace ...',
            );
            $('#txtInputFilename').val('');
            $('#txtInputFilename').trigger('keyup');
          }
        },
      },
      {
        text: 'Cancel',
        id: 'cancelDialogSaveProject',
        icons: {
          primary: 'ui-icon-closethick',
        },
        click: function () {
          $(this).dialog('close');
        },
      },
    ],
  });

  $('.ui-dialog-titlebar-close').hide(); // hide close x icon
  $('#lblSaveProjectMessage').html(''); // reset error message
}

// Die ##LANG_MOUSE## sitzt im ##LANG_HOUSE## xxx
// ERRORTEXT and TRANSLATION functions

function TextTranslate(langObjJSON, strCurrentLang, strToTranslate) {
  var posTargetStart;
  var posTargetEnd;
  var hlpReplString = '';

  // loop over string to translate and find targets
  posTargetStart = strToTranslate.indexOf('##LANG_');
  while (posTargetStart > -1) {
    posTargetEnd = strToTranslate.indexOf('##', posTargetStart + 1);
    hlpReplString = strToTranslate.substr(posTargetStart, posTargetEnd + 2 - posTargetStart);
    hlpReplString = hlpReplString.replace('##LANG_', '');
    hlpReplString = hlpReplString.replace('##', '');

    if (typeof langObjJSON[strCurrentLang][hlpReplString] != 'undefined') {
      strToTranslate = strToTranslate.replace(
        '##LANG_' + hlpReplString + '##',
        langObjJSON[strCurrentLang][hlpReplString],
      );
    } else {
      strToTranslate = strToTranslate.replace(
        '##LANG_' + hlpReplString + '##',
        '=' + GetErrorText('ERR_LANG_01', strCurrentLang, 'short') + hlpReplString + '=',
      );
    }
    posTargetStart = strToTranslate.indexOf('##LANG_');
  }

  return strToTranslate;
}

function GetErrorText(idErrorText, lang, size) {
  var hlpErrorsJSON = AjaxGetJSON('resources/data/validation/errors.json', 'OBJ');
  if (typeof hlpErrorsJSON.errors[0][lang][idErrorText] != 'undefined') {
    return hlpErrorsJSON.errors[0][lang][idErrorText][size];
  } else {
    return idErrorText;
  }
}

function replaceSpecialChars(inpString) {
  var retString = inpString;
  retString = retString.replace(/ /g, '_'); //replace blank with underscore

  return retString;
}

function handleEscStr(mode, inpStr) {
  var retString = 'ERR_NO_ESC';
  var esc = [[',', '*!*']];

  $.each(esc, function () {
    if (mode == 'ESC' && inpStr == $(this)[0]) {
      retString = $(this)[1];
    }
    if (mode == 'UN_ESC' && inpStr == $(this)[1]) {
      retString = $(this)[0];
    }
  });

  return retString;
}

function checkSession(revPiHostname) {
  return '' + Cookies.get('KUNBUS_RevPiSessionId_' + revPiHostname) !== 'undefined';
}

function checkJSONdatatype(objJSON, expectedType) {
  if ($.type(objJSON) == expectedType) {
    return true;
  } else {
    return false;
  }
}

function refreshLoginCookies(expireMin, revPiHostname) {
  if ('' + Cookies.get('KUNBUS_RevPiSessionId_' + revPiHostname) !== 'undefined') {
    var cookieExpire = new Date(new Date().getTime() + expireMin * 60 * 1000);
    Cookies.set('KUNBUS_RevPiUser_' + revPiHostname, Cookies.get('KUNBUS_RevPiUser_' + revPiHostname), {
      expires: cookieExpire,
      secure: true
    });
    Cookies.set('KUNBUS_RevPiSessionId_' + revPiHostname, Cookies.get('KUNBUS_RevPiSessionId_' + revPiHostname), {
      expires: cookieExpire,
      secure: true
    });
  }
}

function getURLParameter(name) {
  return decodeURI((RegExp(name + '=' + '(.+?)(&|$)').exec(location.search) || [, null])[1]);
}

function checkServerHEADMethod() {
  var requestType = 'HEAD';

  $.ajax({
    url: 'resources/js/common.js',
    type: requestType,
    async: false,
    error: function () {
      requestType = 'GET';
    },
  });

  return requestType;
}

function isIPaddressValid(ipaddress) {
  if (
    /^(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$/.test(
      ipaddress,
    )
  ) {
    return true;
  }

  return false;
}

var cntLoop = 5;
function loop() {
  setTimeout(function () {
    // Your logic here
    console.log('seconds elapsed = ' + Math.round(+new Date() / 1000));
    cntLoop--;
    if (cntLoop > 0) {
      loop();
    }
  }, 2000);
}
