<?php
// Redirect to pictory start page
function redirectToPictory($revPiSessionId)
{
   header('Location: /pictory/index.html?hn=' . $revPiSessionId);
   echo "redirect ...";
   exit;
}

// This function ensures that attackers cannot infer details about the exact failure
// as the user always receives the same response. The actual reason is logged to the server logs.
function handleInvalidSSOToken($message)
{
   http_response_code(401);
   echo "401 Unauthorized";
   error_log("sso_login error: " . $message, 0);
   exit;
}

session_start(["cookie_secure" => true, "cookie_httponly" => true]);

// Check if already logged in
if (isset($_SESSION["sso_logged_in"]) && $_SESSION["sso_logged_in"] === true) {
   redirectToPictory($_SESSION['RevPiSessionId']);
   exit;
}

if (!isset($_GET['sso_token'])) {
   handleInvalidSSOToken("No SSO token provided in URL");
}

$sso_token = $_GET['sso_token'];

// Check 1: Validate that the provided SSO token matches the UUID format
if (!preg_match('/^[a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12}$/', $sso_token)) {
   handleInvalidSSOToken("Invalid SSO token format");
}

$sso_token_directory = "/run/cockpit-revpi-pictory-sso";
$sso_file_path = $sso_token_directory . DIRECTORY_SEPARATOR . $sso_token;

// Check 2: Ensure the constructed path $sso_file_path is within $sso_token_directory. By adding a DIRECTORY_SEPARATOR
// to the end of the search string an empty sso_token value is not valid.
$real_sso_file_path = realpath($sso_file_path);
if ($real_sso_file_path === false || strpos($real_sso_file_path, realpath($sso_token_directory) . DIRECTORY_SEPARATOR) !== 0) {
   handleInvalidSSOToken("SSO file not found or invalid path " . $real_sso_file_path);
}

// Check 3: Although realpath already validates the existence of the file, this is checked again here.
if (!file_exists($real_sso_file_path)) {
   handleInvalidSSOToken("SSO file not found");
}

// Read content of the file
$content = file_get_contents($sso_file_path);
$content_array = explode("\n", $content); // split string by newline
$username = $content_array[0]; // the first and currently only line is the username

// User is authenticated via SSO -> create new PHPSESSID to prevent hijackers
session_regenerate_id(true);

// Webstatus login session stored the MD5 of the PHP SessionId
$revPiSessionId = md5(session_id());
// And the JS would then use this hash to set a cookie with this name
// In webstatus the value of the cookie is a incorrectly implemented JWT Token which is actually never read
setcookie('KUNBUS_RevPiSessionId_' . $revPiSessionId, $revPiSessionId, 0, '/', '', true, false);
// pictory ignores the actual value completelly and only checks if this id was stored in the session
$_SESSION['RevPiSessionId'] = $revPiSessionId;

// Mark session as authenticated via SSO
$_SESSION["sso_logged_in"] = true;
$_SESSION["username"] = $username;

// Set SSO cookie to let PiCtory know that it has been started from within cockpit
// Options:
// - secure: true
// - httponly: false (since the main.js needs to access the cookie via Cookie.get() for window.isSSOHost)
// httponly is not required since this cookie does not contain any sensitive data
setcookie('Cockpit_SSO_Host', 'cockpit_sso_host', 0, '/', '', true, false);

// delete the token after session was created
unlink($sso_file_path);

redirectToPictory($revPiSessionId);

?>
