<?php
	session_start();

	$json_params = file_get_contents('php://input');
	$decoded_params = json_decode($json_params);

	if (isset($_SESSION['RevPiSessionId']) && ($decoded_params->RevPiSessionId == $_SESSION['RevPiSessionId'])) {

		$target_dir = $decoded_params->dir;
		# must not contain any dots
		$dot_pattern='/\./';
		# must not start with slash or tilde
		$slash_pattern='/^[\/~]/';

		if(preg_match($dot_pattern, $target_dir) !== 0 || preg_match($slash_pattern, $target_dir) !== 0) {
			return;
		}

		$target_dir = '../'.$target_dir;

		# Verify that the resolved absolute path is within the pictory directory
		# as an additional security measure against directory traversal attacks
		$absolute_target_path = realpath($target_dir);
		$absolute_pictory_path = dirname(__DIR__); // Base directory path for pictory (excludes PHP directory)
		if ($absolute_target_path === false || strpos($absolute_target_path, $absolute_pictory_path) !== 0) {
			return;
		}

		# path is valid, continue file reading
		chdir($target_dir);

		$result = array();
		$handle =  opendir(".");
		while ($datei = readdir($handle))
		{
			if (($datei != '.') && ($datei != '..') && ($datei != '.htaccess'))
			{
				$file = "./".$datei;
				if (!is_dir($file))
					$result[] = $file;
			}
		}
		closedir($handle);
		foreach($result as $r)
			if (file_exists($r))
			echo htmlspecialchars(substr($r,2).",".date ("Y|m|d|H|i|s", filemtime($r)).";");

	} 	else {
			echo "PHP_SESSION_INVALID";
	}
?>
