# Revolution Pi Configurator - piCtory

Browser app to select and configure I/O devices and gateway devices attached to
a RevPi device. Revolution Pi is a set of IoT products based on the Raspberry Pi
and geared towards industrial usage.

# Customization / Whitelabel (non-public)
> *Note:* This section describes a non-public feature

Some OEM customers have customized pictory version where specific design
and wording changes have been made. 
These customizations are own debian packages maintained in private repositories
under https://gitlab.com/revolutionpi/customers/

**Important!**
When changes to specific files like dialogs.html or config.json are made,
always make sure to check if these changes must be migrated
to the customization packages as well!

See README in private repositories for details.

## Version information

The version of this project can be checked in these files:

- `src/pictory/config.json`
- `test/testcafe/tests/pictory/gateways.ts.snapshot`
- `test/testcafe/tests/pictory/device_handling.ts.snapshot`
- `test/testcafe/tests/pictory/device_handling.ts.snapshot`

## SSO Login

From version v2.5.0 on it is possible to seamlessly log into pictory 
from the cockpit-revpi plugin without the need for any other authentication.

You can access cockpit-revpi on your RevPi device via
`https://YOUR-REVPI.local:9090/revpi-config`

## SSO Authentication Details
To authenticate an user in pictory based on an active cockpit session is done via token exchange on 
the filesystem.
A cockpit session runs in the users context on the device and can create
a token file in the users name. Those tokens are created in the folder `/run/cockpit-revpi-pictory-sso` and consists of
a UUID as filename and the username as content.
Cockpit will pass this UUID with the link to pictory's sso_login Route which checks if
a token for this UUID exists and if so, creates an authenticated session for the user.
The token is deleted afterwards so it can only be claimed once.

### Login via Webstatus

Legacy login via webstatus is still possible but is considered deprecated and will be removed
in future versions.

## Reformat RAP files

Use this script to automatically format all *.rap files 

`$ npx prettier --write src/pictory/resources/data/**/*.rap`

## Sudoers file

PiCtory needs root access to revpi-config. In the source code, this is done by
calling "sudo". Since PiCtory runs in the web server as a "www-data" user, a
"sudoers" file must be created to allow access to "revpi-config" as root.

This file is located in `data/sudoers.d/041_www-data-revpi-config-pictory` and
must be installed in `/etc/sudoers.d/`.
