import { Selector } from 'testcafe';

fixture`studio-example`;
/** THIS MUST BE REMOVED AFTER EXPORTING FROM STUDIO
    .page `https://0.0.0.0:41443/index.html`
    .beforeEach(async t => {
        await t
            .typeText('#inpLoginEMail', 'admin')
            .pressKey('tab')
            .typeText('#inpLoginPW', 'raspberry')
            .click('#buttLogin')
            .click('#buttPiCtory');
    });
  */
test('Should display about dialog with Support Forum URL and Email', async (t) => {
  await t
    .hover('#info')
    .click('#info')
    .click('#info_about')
    .expect(Selector('#dialog_splash').visible)
    .ok()
    .expect(
      Selector('#dialog_splash li')
        .withText('Forum: revolutionpi.com/forum/')
        .find('a')
        .getAttribute('href'),
    )
    .eql('https://revolutionpi.com/forum/')
    .expect(
      Selector('#dialog_splash li')
        .withText('Support: support@kunbus.com')
        .find('a')
        .getAttribute('href'),
    )
    .eql('mailto:support@kunbus.com');
});
