# Testcafe Studio Fixtures

Testcafe Studio is a GUI based tool to record and develop testcafe test without the need to write code.

[Documentation](https://docs.devexpress.com/TestCafeStudio/400157/testcafe-studio)

## Integrate recorded tests

To integrate recorded tests in the E2E tests, they must be exported to Javascript and placed next to this README.

[See here](https://docs.devexpress.com/TestCafeStudio/400183/user-interface/fixture-editor#convert-the-fixture-to-javascript)


The exported tests should not contain the actions for logging in, opening pictory
or any page config as this is done in the global config of the E2E tests.

These things can easily be removed from the generated Javascript to make it compatible.

In Testcafe Studio actions for logging in usually are added to `beforeEach` hook so one must not repeat them in every single test.
In the generated Javascript these will be at the very top under the line with the `fixture` header

```js
import { Selector } from 'testcafe';

fixture `studio-example` // <--- Keep this line and any imports above it
  /**
   * Remove everything between here and the first test
   * <REMOVE_START>
   */
    .page `https://0.0.0.0:41443/index.html`
    .beforeEach(async t => {
        await t
            .typeText('#inpLoginEMail', 'admin')
            .pressKey('tab')
            .typeText('#inpLoginPW', 'raspberry')
            .click('#buttLogin')
            .click('#buttPiCtory');
    });
  /**
   * <REMOVE_END>
   */
  
test('first test', async t => { // <--- Keep everything from this line on and lower
  // ...
})

```

### Example and template

There is an example TestCafe Studio Fixture called `./studio-example.testcafe` that can used as a template.
It already contains a `beforeEach` hook with the actions to login to pictory.

The Javascript generated by that TestCafe Studio Fixture is right next to it in `./studio-example.js`.
This file shows the necessary changes to the Code to make this file compatible with the E2E tests
