import { ClientFunction, Role, Selector } from 'testcafe';
import { Editor } from './pictory/pictory.models';
import { targetPassword } from './pictory/utils';

export const AppsPage = {
  pictoryButton: Selector('#buttPiCtory'),
};

export const LoginPage = {
  usernameInput: Selector('#inpLoginEMail'),
  passwordInput: Selector('#inpLoginPW'),
  loginButton: Selector('#buttLogin'),
};

export const adminUser = Role(
  './index.html',
  async (t) => {
    await t
      .typeText(LoginPage.usernameInput, 'admin')
      .typeText(LoginPage.passwordInput, targetPassword)
      .click(LoginPage.loginButton)
      // Open pictory by clicking the button on the webstatus "Apps" page
      .click(AppsPage.pictoryButton);
  },
  { preserveUrl: true },
);

const getUrlPath = ClientFunction(() => window.location.pathname);

/**
 * Assert that the test starts on the correct url and with an empty pictory
 */
export async function expectEmptyPictory(t: TestController) {
  // Expect the current url to be pictory url
  await t
    .expect(getUrlPath.with({ boundTestRun: t })())
    .eql('/pictory/index.html');
  // Check that we start with an empty pictory
  await t
    .expect(
      Editor.ConfiguredDevices.all.with({ timeout: 3000, boundTestRun: t })
        .count,
    )
    .eql(0);
}
