#!/bin/bash
set -e

######
# Entrypoint for docker container running in CI pipeline
# Replaces pictory and testcafe folders with the current pictory sources and current e2e test sources from the
# repository that the CI clones to $CI_PROJECT_DIR
######

if [ -z "$CI_PROJECT_DIR" ]; then
echo "Not in CI pipeline. Do not run this script manually!"
exit 1
fi

DIRNAME=$(dirname "$0")
BASEDIR=$(realpath "$DIRNAME")

# Remove pre-installed pictory
rm -rf /var/www/revpi/pictory
# Copy current pictory sources to pre-installed webstatus folder
cp -r "$CI_PROJECT_DIR"/src/pictory /var/www/revpi/
chown -R www-data:www-data /var/www/revpi/pictory

# Remove pre-installed tests
rm -rf /opt/testcafe/tests
# Copy current test sources to pre-installed testcafe
cp -r "$CI_PROJECT_DIR"/test/testcafe/tests /opt/testcafe

cd /opt/testcafe

"$BASEDIR/docker-entrypoint.sh"
