# Testing & developing pictory
To start pictory on your local machine it can be mounted in a Docker container running webstatus

As long as the container is running, webstatus is available at https://0.0.0.0:41443

The local state of the pictory sources will be mounted in the container.
This means:

1. Your local changes to the source code will be immediately available in the pictory instance running in the container
2. Pictory will save any project configurations to your local repository.  
Watch out for changed files in the **pictory/projects/** folder
 

1. Start the container with this command

```shell
$ ./docker-dev.sh
```

**The local sources will be mounted in the container**

2. Access webstatus at   
https://0.0.0.0:41443

Login with

> User: admin   
> Password: raspberry

3. Pictory will then be available at   
https://0.0.0.0:41443/pictory

> **NOTE:** This is only meant for testing simple things in the PHP Code 
> or in the website.
> 
> Anything that needs an actual device will not work!



# End-to-end Tests with Testcafe
The most important use cases of pictory are covered by E2E tests implemented with [Testcafe](https://testcafe.io/)

To ensure each test runs with a clean pictory instance, the projects/ folder in pictory is restored after each test.
Therefore the test runner needs access to the same files as the pictory instance. 

The E2E test can be started locally or within a docker container

These tests will be **automatically** executed in the Gitlab CI

## Run with docker
To run these tests in docker against a local pictory development instance use
```shell
$ ./docker-test.sh
```
This will mount the current test and pictory sources and starts a pictory instance to run the tests against 

## Run locally

To run these tests on your local machine you must have a pictory instance running and make the path to its directory 
available for the tests.
Testcafe is a Node.js application and to run it locally you must prepare your environment.
Navigate to test/testcafe, install dependencies from the package.json and start the test via npm
```shell
$ cd test/testcafe/
$ npm install
$ npm run test:dev
```

If you need to provide a different pictory path use
```shell
$ TEST_PICTORY_PATH=/path/to/pictory npm run test
```

If you want to actually see the tests being executed in a browser GUI window use this:
```shell
$ SHOW_BROWSER=1 npm run test
```

## Snapshots
After each test case the pictory configuration `_config.rsc` will be compared with a snapshot
that was generated and commited previously for this test case.

The snapshots were generated in a "know-good state" and therefore represent exactly the expected output

If anything in this snapshot differs, then something modified the application in a way that caused a different result.  
That is considered a critical error as we expect pictory to always generated the exact same `_config.rsc` file
unless specific changes were made to alter this behaviour.


### Updating Snapshots
The snapshots must never be altered. Only if a planned feature or approved bug fix changes the internal workings
of PiCtory, and even then only after these changes were thoroughly tested, the snapshots may be updated to represent this new state.

If this must be done, run the tests locally with the environment variable `SNAPSHOT_UPDATE` set to `1` (actual value doesn't matter)
```shell
$ SNAPSHOT_UPDATE=1 npm run test:dev
```

> **NOTE:** The docker-dev.sh must bestarted before the tests can be run with
> the `SNAPSHOT_UPDATE` environment variable set.

**Note:** When the snapshots are updated, all snapshot tests are considered successful 
as the old snapshots cannot be used for comparison anymore.
The normal test cases are still executed and evaluated as usual.

After the snapshots have been updated run the tests again without `SNAPSHOT_UPDATE` set (meaning not set at all!)
to validate that the new snapshots are consistently being reproduced in the exact same way.

Then commit the new snapshots with a commit message that mentions, why the snapshots have been updated.
