// Optional global config object for customization
window.pictory = window.pictory ?? {};

$.ajaxSetup({
  data: { RevPiSessionId: Cookies.get('KUNBUS_RevPiSessionId_' + getURLParameter('hn')) },
});
// STRING functions

function pad(n, width, z) {
  z = z || '0';
  n = n + '';
  if (isNaN(width)) {
    return '';
  }
  return n.length >= width ? n : new Array(width - n.length + 1).join(z) + n;
}

// FILE functions

function fileExists(url) {
  var ret = false;

  // if global variable is defined, use it as request type
  // if not, use GET request since this MUST work
  var requestType = 'GET';
  if (typeof fileExistsRequestMethod != 'undefined') {
    requestType = fileExistsRequestMethod;
  }

  $.ajax({
    url: url,
    type: requestType,
    async: false,
    error: function () {
      ret = false;
    },
    success: function () {
      ret = true;
    },
  });

  return ret;
}

function AjaxDeleteFile(pathname) {
  var hlpRet = '';
  var JSONdata =
    "{'pathname': " + pathname + ",'RevPiSessionId': '" + Cookies.get('KUNBUS_RevPiSessionId_' + revPiHostname) + "'}";
  JSONdata = JSONdata.replace(/'/g, '"');

  $.ajax({
    async: false,
    url: 'php/deleteFile.php',
    type: 'POST',
    data: JSONdata,
    processData: false,
    dataType: 'text',
    contentType: 'application/json; charset=utf-8',
    success: function (response) {
      hlpRet = response;
      if (hlpRet == 'PHP_SESSION_INVALID') {
        // if no valid server session can be found, remove client cookies also
        Cookies.remove('KUNBUS_RevPiUser_' + revPiHostname);
        Cookies.remove('KUNBUS_RevPiSessionId_' + revPiHostname);
        createInfoDialog('Timeout', '<br>' + 'Session expired ...', '');
      }
    },
  });
}

function AjaxRenameFile(mode) {
  var hlpRet = '';
  var JSONdata =
    "{'mode': " + mode + ",'RevPiSessionId': '" + Cookies.get('KUNBUS_RevPiSessionId_' + revPiHostname) + "'}";
  JSONdata = JSONdata.replace(/'/g, '"');

  $.ajax({
    async: false,
    cache: false,
    url: 'php/renameFile.php',
    type: 'POST',
    data: JSONdata,
    processData: false,
    dataType: 'text',
    contentType: 'application/json; charset=utf-8',
    success: function (response) {
      hlpRet = response;
      if (hlpRet == 'PHP_SESSION_INVALID') {
        // if no valid server session can be found, remove client cookies also
        Cookies.remove('KUNBUS_RevPiUser_' + revPiHostname);
        Cookies.remove('KUNBUS_RevPiSessionId_' + revPiHostname);
        createInfoDialog('Timeout', '<br>' + 'Session expired ...', '');
      }
    },
  });
}

function AjaxResetDriver(dummy) {
  var hlpRet = '';

  var JSONdata = "{'RevPiSessionId': '" + Cookies.get('KUNBUS_RevPiSessionId_' + revPiHostname) + "'}";
  JSONdata = JSONdata.replace(/'/g, '"');

  $.ajax({
    async: false,
    url: 'php/resetDriver.php',
    type: 'POST',
    data: JSONdata,
    processData: false,
    dataType: 'text',
    contentType: 'application/json; charset=utf-8',
    success: function (response) {
      hlpRet = response;
      if (hlpRet == 'PHP_SESSION_INVALID') {
        // if no valid server session can be found, remove client cookies also
        Cookies.remove('KUNBUS_RevPiUser_' + revPiHostname);
        Cookies.remove('KUNBUS_RevPiSessionId_' + revPiHostname);
        createInfoDialog('Timeout', '<br>' + 'Session expired ...', '');
      } else {
        if (hlpRet != 0) {
          createInfoDialog('Error', '<br>' + 'Unable to reset driver ...', '');
        }
      }
    },
  });

  //alert(hlpRet);
}

function AjaxRunActions(reset, start, showResponse) {
  var hlpRet = '';
  var JSONdata = '{##RESET##,##START##,##REVPISESSIONID##}';

  // handle parameters; param. which are -false- will NOT be given over to PHP script at all
  if (reset == true) {
    JSONdata = JSONdata.replace('##RESET##', "'reset':true");
  } else {
    JSONdata = JSONdata.replace('##RESET##', "'reset':false");
  }

  if (start == true) {
    JSONdata = JSONdata.replace('##START##', "'start':true");
  } else {
    JSONdata = JSONdata.replace('##START##', "'start':false");
  }

  JSONdata = JSONdata.replace(
    '##REVPISESSIONID##',
    "'RevPiSessionId':'" + Cookies.get('KUNBUS_RevPiSessionId_' + revPiHostname) + "'",
  );
  JSONdata = JSONdata.replace(/'/g, '"');

  $.ajax({
    async: false,
    url: 'php/runActions.php',
    type: 'POST',
    data: JSONdata,
    processData: false,
    dataType: 'text',
    contentType: 'application/json; charset=utf-8',
    success: function (response) {
      hlpRet = response;
      if (hlpRet == 'PHP_SESSION_INVALID') {
        // if no valid server session can be found, remove client cookies also
        Cookies.remove('KUNBUS_RevPiUser_' + revPiHostname);
        Cookies.remove('KUNBUS_RevPiSessionId_' + revPiHostname);
        createInfoDialog('Timeout', '<br>' + 'Session expired ...', '');
      }
    },
  });

  if (showResponse == true) {
    if (hlpRet == 'OK') {
      createInfoDialog('', '<br>Success ...', '{"autoClose":1000}');
    } else {
      createInfoDialog('', '<br>ERROR:' + hlpRet, '{}');
    }
  }
}

function AjaxGetIfconfigInfo() {
  var retJSON = '';
  var JSONdata = "{'mode':'GET_IFCONFIGINFO'}";

  JSONdata = JSONdata.replace(/'/g, '"');

  $.ajax({
    async: false,
    url: 'php/scanIPRange.php',
    type: 'POST',
    data: JSONdata,
    processData: false,
    dataType: 'text',
    contentType: 'application/json; charset=utf-8',
    success: function (response) {
      try {
        retJSON = JSON.parse(response);
      } catch (e) {
        retJSON = '';
      }
    },
    error: function (jqXHR, textStatus, errorThrown) {
      alert('Error in AjaxGetIfconfigInfo: ' + errorThrown);
    },
  });

  if (retJSON != '') {
    return retJSON;
  } else {
    return 'ERR_NO_DATA';
  }
}

function AjaxGetIPRange(startIP, netMask) {
  var JSONdata = "{'mode':'GET_IPRANGE','startIP':'##START_IP##','netMask':'##NET_MASK##'}";

  JSONdata = JSONdata.replace('##START_IP##', startIP);
  JSONdata = JSONdata.replace('##NET_MASK##', netMask);
  JSONdata = JSONdata.replace(/'/g, '"');

  $.ajax({
    async: false,
    url: 'php/scanIPRange.php',
    type: 'POST',
    data: JSONdata,
    processData: false,
    dataType: 'text',
    contentType: 'application/json; charset=utf-8',
    success: function (response) {
      try {
        retJSON = JSON.parse(response);
      } catch (e) {
        retJSON = '';
      }
    },
    error: function (jqXHR, textStatus, errorThrown) {
      alert('Error in AjaxScanIPRange: ' + errorThrown);
    },
  });

  if (retJSON != '') {
    return retJSON;
  } else {
    return 'ERR_NO_DATA';
  }
}

function AjaxScanIPRange(arrIpRange, port) {
  var retJSON = '';
  var JSONdata = "{'mode':'SCAN_IPRANGE','ipRange':[##IP_RANGE##],'port':##PORT##}";

  JSONdata = JSONdata.replace('##IP_RANGE##', arrIpRange);
  JSONdata = JSONdata.replace('##PORT##', port);
  JSONdata = JSONdata.replace(/'/g, '"');

  $.ajax({
    async: false,
    url: 'php/scanIPRange.php',
    type: 'POST',
    data: JSONdata,
    processData: false,
    dataType: 'text',
    contentType: 'application/json; charset=utf-8',
    success: function (response) {
      try {
        retJSON = JSON.parse(response);
      } catch (e) {
        retJSON = '';
      }
    },
    error: function (jqXHR, textStatus, errorThrown) {
      alert('Error in AjaxScanIPRange: ' + errorThrown);
    },
  });

  if (retJSON != '') {
    return retJSON;
  } else {
    return 'ERR_NO_DATA';
  }
}

// CONTROL handling functions
function setSelectByValue(eID, val) {
  //Loop through sequentially//
  var ele = document.getElementById(eID);
  for (var ii = 0; ii < ele.length; ii++) {
    if (ele.options[ii].value == val) {
      //Found!
      ele.options[ii].selected = true;
      return true;
    }
  }

  return false;
}

function setSelectByText(eID, text) {
  //Loop through sequentially//
  var ele = document.getElementById(eID);
  for (var ii = 0; ii < ele.length; ii++) {
    if (ele.options[ii].text == text) {
      //Found!
      ele.options[ii].selected = true;
      return true;
    }
  }

  return false;
}

function setSelectByIndex(eId, index) {
  $('#' + eId).prop('selectedIndex', index);
  return true;
}

// DATA ACCESS LAYER

function AjaxGetJSON(parPathname, mode) {
  //console.log("CACHE: " + Cookies.get('KUNBUS_PiCtory_Cache'));

  var hlpPathname = parPathname;
  var retJSON = '';
  var useCache = true;

  //exclude special files from alerting when file not exists OR is empty (like _config.rsc on first start)
  var arrFilesNoAlert = ['php/getProjectFile.php?fn=_config.rsc'];
  var shouldLogError = $.inArray(parPathname, arrFilesNoAlert) == -1;
  // exclude certain file types from caching ...
  // explicitly exclude _userSettings.json to force change of Settings/Cache mode
  if (parPathname.toLowerCase().indexOf('.rsc') > -1 || parPathname.toLowerCase().indexOf('_usersettings.json') > -1) {
    useCache = false;
  } else {
    // suspend caching when Cache-Cookie is set (e.g. on reload via menu)
    if (typeof Cookies.get('KUNBUS_PiCtory_Cache') != 'undefined') {
      hlpPathname = hlpPathname + '?_=' + Cookies.get('KUNBUS_PiCtory_Cache');
    } else {
      // set caching according to user settings
      if (userSettingsData != '') {
        if (userSettingsData.hasOwnProperty('03')) {
          useCache = userSettingsData['03'].mode == 0 ? true : false;
        }
      }
    }
  }

  $.ajax({
    url: hlpPathname,
    type: 'get',
    async: false,
    cache: useCache,
    dataType: 'text',
    beforeSend: function (xhr) {
      /* prevents - not well formed XML - warning in Firefox browsers */
      if (xhr.overrideMimeType) {
        xhr.overrideMimeType('application/json');
      }
    },
    success: function (data) {
      // remove CR/LF
      // this allows string literals to have CR/LF content for better readability
      data = data.replace(/(\r\n|\n|\r)/gm, '');
      data = data.replace(/\t+/g, '');
      if (mode == 'OBJ') {
        try {
          retJSON = JSON.parse(data);
        } catch (e) {
          retJSON = '';
        }
      } else {
        // return JSON as String
        retJSON = data;
      }
    },
    error: function (jqXHR, textStatus, errorThrown) {
      if (shouldLogError) {
        alert('Error in AjaxGetJSON: ' + errorThrown);
      }
    },
  });

  if (retJSON !== '') {
    return retJSON;
  } else {
    if (shouldLogError) {
      alert(parPathname + ': required JSON file not available or invalid!');
    }
    return 'ERR_NO_DATA';
  }
}

function GetJSONData(mode, pathname, selector) {
  var jsonDataObj;

  if (mode == 'DATATYPES') {
  }

  if (mode == 'CATALOG') {
    jsonDataObj = AjaxGetJSON(pathname != '' ? pathname : 'resources/data/catalog.json', 'OBJ');
    if (fileExists(configData.paths['catalog-custom'])) {
      jsonDataObj = appendCatalogCustom(jsonDataObj);
    }
    var resultObj = JSONSelect.match(selector, jsonDataObj);
  }

  if (mode == 'GSD') {
    jsonDataObj = AjaxGetJSON(pathname, 'OBJ');
    var resultObj = JSONSelect.match(selector, jsonDataObj);
  }

  return resultObj;
}

// MISC functions
//
//
function sortJSON(objJSON, prop) {
  var retJSON = objJSON;
  return _.sortBy(retJSON, prop);
}

function killLastDelimiter(inpString, delimiter) {
  var retString = $.trim(inpString);
  if (retString != '') {
    if (retString.substr(retString.length - delimiter.length, delimiter.length) == delimiter) {
      retString = retString.substr(0, retString.length - delimiter.length);
    }
  }
  return retString;
}

function getPosDelimiter(inpString, delimiter, delPos) {
  var retPos = -1;
  var cntDelimiters = delPos;
  var arrPosDelimiters = [];
  var posDelimiter = inpString.indexOf(delimiter);
  while (posDelimiter > -1) {
    arrPosDelimiters.push(posDelimiter);
    posDelimiter = inpString.indexOf(delimiter, posDelimiter + 1);
  }

  if (arrPosDelimiters.length > 0) {
    if (isNaN(delPos)) {
      // special delPos
      if (delPos == 'FIRST') {
        retPos = arrPosDelimiters[0];
      }
      if (delPos == 'LAST') {
        retPos = arrPosDelimiters[arrPosDelimiters.length - 1];
      }
    } else {
      // numeric delPos
      if (delPos <= arrPosDelimiters.length) {
        retPos = arrPosDelimiters[delPos - 1];
      }
    }
  }

  return retPos;
}

function getCountAvailableHosts(strNetmask) {
  var allBits = '';
  var arrIPparts = strNetmask.split('.');
  $.each(arrIPparts, function (index, IPpart) {
    allBits = allBits + pad(parseInt(IPpart).toString(2), 8);
  });

  return Math.pow(2, (allBits.match(/0/g) || []).length) - 2; // subtract 2 since 0 and 255 are not allowed
}

function createConfirmDialog(mode) {
  $('#dialog_confirm').dialog({
    width: 550,
    modal: true,
    show: { effect: 'blind', duration: 400 },
    buttons: [
      {
        text: 'Ok',
        icons: {
          primary: 'ui-icon-heart',
        },
        click: function () {
          $(this).dialog('close');
          confirmResult = true; // declared in main.js
          processConfirm();
        },
      },
      {
        text: 'Cancel',
        icons: {
          primary: 'ui-icon-closethick',
        },
        click: function () {
          $(this).dialog('close');
          confirmResult = false; // declared in main.js
          processConfirm();
        },
      },
    ],
  });

  if (mode == 'CLEAR' || mode == 'OPEN_PROJECT') {
    $('#lblConfirmMessage').html('Data of current project will be lost!');
  }

  if (mode == 'EXIT') {
    $('#lblConfirmMessage').html('Project has unsaved changes!');
  }

  if (mode == 'RESET_DATA') {
    $('#lblConfirmMessage').html('Data of device will be lost!');
  }
}

function createExtendedDataDialog(productType) {
  $('#dialog_extendedData_' + productType).dialog({
    width: 1024,
    height: 610,
    modal: true,
    resizable: false,
    title: 'Extended Data',
    show: { effect: 'blind', duration: 200 },
    buttons: [
      {
        text: 'Ok',
        icons: {
          primary: 'ui-icon-heart',
        },
        click: function () {
          $(this).dialog('close');
        },
      },
    ],
  });

  $('.ui-dialog-titlebar-close').hide(); // hide close x icon
}

function createInfoDialog(mode, infotext, options) {
  var hlpMode = mode == '' ? 'Info' : mode;
  var titleText;
  var titleColor;

  if (hlpMode == 'Info') {
    titleText = hlpMode;
    titleColor = '#000000';
  }
  if (hlpMode == 'Error' || hlpMode == 'Timeout') {
    titleText = hlpMode;
    titleColor = window.pictory.primaryColor ?? '#ff6600';
  }

  var hlpOptions = JSON.parse('{}');
  if (options != '') {
    hlpOptions = JSON.parse(options);
  }

  $('#dialog_info')
    .dialog({
      height: hlpOptions.hasOwnProperty('height') == true ? hlpOptions.height : 200,
      width: hlpOptions.hasOwnProperty('width') == true ? hlpOptions.width : 400,
      modal: hlpOptions.hasOwnProperty('modal') == true ? hlpOptions.modal : true,
      resizable: hlpOptions.hasOwnProperty('resizable') == true ? hlpOptions.resizable : false,
      title: hlpOptions.hasOwnProperty('title') == true ? hlpOptions.title : titleText,
      show: { effect: 'blind', duration: 200 },
      buttons: {
        Ok: function () {
          $(this).dialog('close');
          if (hlpMode == 'Timeout') {
            // return to login page
            window.location.href = window.isSSOHost ? 'php/logout.php' : configData.paths.login;
          }
        },
      },
      open: function (event, ui) {
        $('#lblDialogInfo').html(infotext);
        if (hlpOptions.hasOwnProperty('autoClose')) {
          $('#dialog_info').dialog('option', 'buttons', {}); // remove OK button when autoClose
          setTimeout("$('#dialog_info').dialog('close')", hlpOptions.autoClose);
        }
      },
    })
    .prev('.ui-dialog-titlebar')
    .css('background', titleColor);
}

function createConnectionDialog(mode) {
  $('#dialog_manageConnections').dialog({
    width: 1024,
    height: 650,
    modal: true,
    resizable: false,
    title: 'Manage Connections',
    show: { effect: 'blind', duration: 200 },
    buttons: [
      {
        text: 'Ok',
        icons: {
          primary: 'ui-icon-heart',
        },
        click: function () {
          $(this).dialog('close');
        },
      },
    ],
  });

  $('.ui-dialog-titlebar-close').hide(); // hide close x icon
}

function createEditRAPDialog(deviceId) {
  $('#dialog_editRAP').dialog({
    width: 1024,
    height: 650,
    modal: true,
    resizable: false,
    title: 'RAP Editor',
    show: { effect: 'blind', duration: 200 },
    buttons: [
      {
        text: 'Ok',
        icons: {
          primary: 'ui-icon-heart',
        },
        click: function () {
          $(this).dialog('close');
        },
      },
    ],
  });

  fillEditRAPDialog(deviceId);
}

function fillEditRAPDialog(deviceId) {
  $('#dialog_editRAP').dialog('option', 'title', 'RAP Editor - Device: ' + deviceId);
}

function createScanDevicesDialog() {
  $('#dialog_scanDevices').dialog({
    width: 700,
    height: 500,
    modal: true,
    resizable: false,
    title: 'Scan for Devices',
    show: { effect: 'blind', duration: 200 },
    buttons: [
      {
        text: 'Ok',
        icons: {
          primary: 'ui-icon-heart',
        },
        click: function () {
          $(this).dialog('close');
        },
      },
    ],
  });

  fillScanDevicesDialog('');

  $('.ui-dialog-titlebar-close').hide(); // hide close x icon
}

function fillScanDevicesDialog() {
  // FOR TESTING
  //var arrToScanJSON = [{"ifname": "eth0:","ipaddr": "192.168.1.83","netmask": "255.255.255.0"},{"ifname": "lo:","ipaddr": "127.0.0.1","netmask": "255.0.0.0"}];
  var arrToScanJSON = AjaxGetIfconfigInfo();
  var hlpClone = '';
  var cntRangeTooLarge = 0;
  var swtAbort = false;

  // remove results from previous opening of dialog
  $('#tblInterfaces tbody tr:gt(0)').remove();
  $('#lblMessageScanDevices').html('');
  $('#lblMessageScanDevicesProgress').html('');
  $('#lblMessageScanResults').html('');
  $('#tblScanResults').hide();
  $("[id^='trScanResults_']").remove();
  $('#btnAddDevices').hide();
  $('#lblMessageAddDevices').html('');

  $.each(arrToScanJSON, function (index, interfaceData) {
    hlpClone = $('#tmplRowInterfaces').clone();
    hlpClone.html(hlpClone.html().replace('##TD_IF_NAME##', 'tdIfName_' + interfaceData.ifname.replace(':', '')));
    hlpClone.html(hlpClone.html().replace('##IF_NAME##', interfaceData.ifname.replace(':', '')));
    hlpClone.html(hlpClone.html().replace('##TD_IF_IP##', 'tdIfIP_' + interfaceData.ifname.replace(':', '')));
    hlpClone.html(hlpClone.html().replace('##IF_NAME##', interfaceData.ipaddr));
    hlpClone.html(hlpClone.html().replace('##TD_IF_NETMASK##', 'tdIfNetmask_' + interfaceData.ifname.replace(':', '')));
    hlpClone.html(hlpClone.html().replace('##IF_NETMASK##', interfaceData.netmask));
    hlpClone.html(hlpClone.html().replace('##TD_IF_ALERT##', 'tdIfAlert_' + interfaceData.ifname.replace(':', '')));
    hlpClone.html(hlpClone.html().replace('##CHK_IF_SCAN##', 'chkIfScan_' + interfaceData.ifname.replace(':', '')));

    // range too large ... set icon
    if (getCountAvailableHosts(interfaceData.netmask) > 256) {
      hlpClone.html(hlpClone.html().replace('##IF_ALERT##', "<span class='ui-icon ui-icon-alert'></span>"));
      cntRangeTooLarge++;
    } else {
      hlpClone.html(hlpClone.html().replace('##IF_ALERT##', ''));
    }

    // append row to table
    $('#tblInterfaces tbody').append(hlpClone);

    // range too large - set td background ...
    if (getCountAvailableHosts(interfaceData.netmask) > 256) {
      $('#tdIfAlert_' + interfaceData.ifname.replace(':', '')).css('background-color', 'red');
    } else {
      // pre-check scan checkbox for range which are NOT too large ...
      $('#chkIfScan_' + interfaceData.ifname.replace(':', '')).prop('checked', true);
    }

    $('#tblInterfaces tr:last').attr('id', 'trInterface_' + interfaceData.ifname.replace(':', ''));
    $('#trInterface_' + interfaceData.ifname.replace(':', '')).show();
  });

  // hide -range too large- info if no range is too large ...
  if (cntRangeTooLarge == 0) {
    $('#trScanRangeTooLarge').hide();
  }

  $('#btnScanDevices').off();
  $('#btnScanDevices').on('click', function (e) {
    var hndlTimeout;
    var cntRange;
    var cntOpen = 0;
    var cntAll = 0;
    var arrIpRange;
    var arrNextScanRange;
    var arrRetScan;
    var hlpClone;
    var currentScanIP = '';
    var currentScanNetmask = '';

    swtAbort = false;

    // reset
    $('#lblMessageScanDevices').html('');
    $('#lblMessageScanDevicesProgress').html('');
    $('#lblMessageScanResults').html('');
    $('#tblScanResults').hide();
    $("[id^='trScanResults_']").remove();
    $('#lblScanResults').html('<br>');
    $('#btnAddDevices').hide();
    $('#lblMessageAddDevices').html('');

    if ($("[id^='chkIfScan_']:checked").length == 0) {
      $('#lblMessageScanDevices').css({ color: 'red', 'font-weight': 'bold' });
      $('#lblMessageScanDevices').html('Please check at least one interface to scan for devices ...');
    } else {
      $('#lblMessageScanDevices').css({ color: 'blue', 'font-weight': 'bold' });
      $('#lblMessageScanDevices').html('Scan in progress ... please wait');
      $('#btnAbortScanDevices').show();
      $('#btnScanDevices').hide();

      $('#btnAbortScanDevices').off();
      $('#btnAbortScanDevices').on('click', function (e) {
        swtAbort = true;
        clearTimeout(hndlTimeout);

        $('#lblMessageScanDevices').css({ color: 'red', 'font-weight': 'bold' });
        $('#lblMessageScanDevices').html('Scanning ABORTED ...');
        $('#lblMessageScanDevicesProgress').html('');
        $('#btnScanDevices').show();
        $('#btnAbortScanDevices').hide();
        // show Add button if devices to add have been found
        if ($("[id^='chkSrAdd_']:checked").length > 0) {
          $('#btnAddDevices').show();
        }

        return;
      });

      // Loop Level 01: over Interfaces
      $("[id^='chkIfScan_']:checked").each(function () {
        hlpIf = $(this).attr('id').replace('chkIfScan_', '');
        currentScanIP = $('#tdIfIP_' + hlpIf).html();
        currentScanNetmask = $('#tdIfNetmask_' + hlpIf).html();

        // Loop Level 02: over IP ranges in steps of 5
        // IMPORTANT: loop is done with -setInterval- to allow for -Abort- button to receive click event ...

        // get full IP range to scan for this interface!
        arrIpRange = AjaxGetIPRange(currentScanIP, currentScanNetmask);
        cntRange = 1;
        arrNextScanRange = getNextScanRange(arrIpRange, cntRange);

        function doScan() {
          // IMPORTANT: use chronos setTimeout for better responsivenes of GUI while loop is performed
          // especially in Firefox browsers!
          // Without this, triggering the 'abort' event by clicking the Abort-Button is much more difficult ...
          hndlTimeout = chronos.setTimeout(function () {
            // Your logic here
            //console.log("seconds elapsed = " + Math.round(+new Date()/1000));

            // show progress ...
            $('#lblMessageScanDevicesProgress').html(
              '<br>scanning: ' +
              currentScanIP +
              ' (' +
              (cntRange * CONST_SCAN_RANGE_SIZE <= arrIpRange.length
                ? cntRange * CONST_SCAN_RANGE_SIZE
                : arrIpRange.length) +
              ' of ' +
              arrIpRange.length +
              ') ',
            );
            arrRetScannedIPs = AjaxScanIPRange(arrNextScanRange, CONST_MODBUS_SCAN_PORT);
            $.each(arrRetScannedIPs, function (index, scannedIP) {
              cntAll++;
              hlpClone = $('#tmplRowScanResults').clone();

              hlpClone.html(hlpClone.html().replace('##TD_SR_IP##', 'tdSrIP_' + scannedIP.host.replace(/\./g, '_')));
              hlpClone.html(hlpClone.html().replace('##SR_IP##', scannedIP.host));
              hlpClone.html(
                hlpClone.html().replace('##TD_SR_PORT##', 'tdSrPort_' + scannedIP.host.replace(/\./g, '_')),
              );
              hlpClone.html(hlpClone.html().replace('##SR_PORT##', scannedIP.port));
              hlpClone.html(
                hlpClone.html().replace('##TD_SR_NAME##', 'tdSrName_' + scannedIP.host.replace(/\./g, '_')),
              );
              if (scannedIP.open == true) {
                cntOpen++;
                hlpClone.html(hlpClone.html().replace('##SR_NAME##', 'UNKNOWN'));
              } else {
                hlpClone.html(hlpClone.html().replace('##SR_NAME##', '-'));
              }
              hlpClone.html(
                hlpClone.html().replace('##TD_SR_OPEN##', 'tdSrOpen_' + scannedIP.host.replace(/\./g, '_')),
              );
              hlpClone.html(hlpClone.html().replace('##SR_OPEN##', scannedIP.open));
              hlpClone.html(
                hlpClone.html().replace('##TD_SR_MESSAGE##', 'tdSrMessage_' + scannedIP.host.replace(/\./g, '_')),
              );
              hlpClone.html(hlpClone.html().replace('##SR_MESSAGE##', scannedIP.message));
              hlpClone.html(
                hlpClone.html().replace('##CHK_SR_ADD##', 'chkSrAdd_' + scannedIP.host.replace(/\./g, '_')),
              );

              // append row to table
              $('#tblScanResults tbody').append(hlpClone);

              // add custom attribute for filtering
              $('#tdSrOpen_' + scannedIP.host.replace(/\./g, '_')).data('open', scannedIP.open);

              // remove add checkbox
              if (scannedIP.open == false) {
                // since checkboxes are all pre-checked, hiding is not enough
                // to prevent them from being used when the 'Add' button is clicked!
                $('#chkSrAdd_' + scannedIP.host.replace(/\./g, '_')).remove();
              }

              $('#tblScanResults tr:last').attr('id', 'trScanResults_' + scannedIP.host.replace(/\./g, '_'));

              // show results table depending on 'Show All' mode
              if (isScanResultsTableVisible() == true) {
                $('#tblScanResults').show();
              } else {
                $('#tblScanResults').hide();
              }

              // show row depending on 'show all' checkbox
              if ($('#chkScanShowAll').prop('checked') == true || scannedIP.open == true) {
                $('#trScanResults_' + scannedIP.host.replace(/\./g, '_')).show();
              }
            }); // end each

            cntRange++;
            arrNextScanRange = getNextScanRange(arrIpRange, cntRange);

            // check if we are finished yet or have aborted ...
            if (arrNextScanRange != '' && swtAbort == false) {
              clearTimeout(hndlTimeout); // cancel previous timeout if it
              doScan(); // continue!
            } else {
              // after Loop Level 2 ... either by abort or by end of range reached
              if (swtAbort == true) {
                $('#lblMessageScanDevices').css({ color: 'red', 'font-weight': 'bold' });
                $('#lblMessageScanDevices').html('Scanning ABORTED ...');
                $('#lblMessageScanDevicesProgress').html('');
                $('#btnScanDevices').show();
                $('#btnAbortScanDevices').hide();
                // show Add button if devices to add have been found
                /*
                if ($("[id^='chkSrAdd_']:checked").length > 0) {
                  $("#btnAddDevices").show();					
                }
                */
              } else {
                $('#lblMessageScanDevices').css({ color: 'green', 'font-weight': 'bold' });
                $('#lblMessageScanDevices').html('Scanning completed ...');
              }

              // adapt whether devices have been found or not
              if (cntOpen == 0) {
                // show message
                $('#lblMessageScanResults').css({ color: 'red', 'font-weight': 'bold' });
                $('#lblMessageScanResults').html('NO DEVICES FOR ADDING FOUND');
                // hide add button
                $('#btnAddDevices').hide();
              } else {
                if (isScanResultsTableVisible() == true) {
                  $('#tblScanResults').show();
                  $('#btnAddDevices').show();
                } else {
                  $('#tblScanResults').hide();
                  $('#btnAddDevices').hide();
                }
              }

              $('#btnAbortScanDevices').hide();
              $('#btnScanDevices').show();
            }
          }, 100);
        }

        doScan(); // start scanning loop ...
      }); // end loop 01
    }
  });

  $('#chkScanShowAll').off();
  $('#chkScanShowAll').on('change', function (e) {
    if ($('#chkScanShowAll').prop('checked') == true) {
      if ($("[id^='trScanResults_']").length > 0) {
        $("[id^='trScanResults_']").show();
      }
    } else {
      $("[id^='tdSrOpen_']").each(function (index) {
        if ($(this).data('open') == false) {
          $(this).closest('tr').hide();
        }
      });
    }

    if (isScanResultsTableVisible() == true) {
      $('#tblScanResults').show();
      $('#btnAddDevices').show();
    } else {
      $('#tblScanResults').hide();
      $('#btnAddDevices').hide();
    }
  });

  $('#btnAddDevices').off();
  $('#btnAddDevices').on('click', function (e) {
    if ($("[id^='chkSrAdd_']:checked").length == 0) {
      alert('No devices checked for adding ...');
    } else {
      // find table cell of RevPi base device
      var objDropCell;
      var objDeviceImg;
      var swtFound = false;
      var appendedDeviceId = '';
      var deviceIP = '';
      var arrDeviceValues;
      var swtIpExists = false;
      var swtAnyIpExisted = false;

      $('td.dropCell.ui-droppable').each(function () {
        objDropCell = $(this);
        objDeviceImg = $(this).find('img');
        if (
          objDeviceImg.length > 0 &&
          (objDeviceImg.attr('id').indexOf('RevPiCore') > -1 ||
            objDeviceImg.attr('id').indexOf('RevPiConnect') > -1 ||
            objDeviceImg.attr('id').indexOf('RevPiCompact') > -1 ||
            objDeviceImg.attr('id').indexOf('RevPiFlat') > -1)
        ) {
          swtFound = true;
          return false;
        }
      });

      if (swtFound == true) {
        $('#lblMessageAddDevices').css({ color: 'blue', 'font-weight': 'bold' });
        $('#lblMessageAddDevices').html('Please wait ...');

        // put this in setTimeout to enable GUI refresh to show message ...
        hndlTimeout = chronos.setTimeout(function () {
          $("[id^='chkSrAdd_']:checked").each(function (index) {
            deviceIP = $(this).attr('id').replace('chkSrAdd_', '');
            deviceIP = deviceIP.replace(/_/g, '.');
            swtIpExists = false;
            // check if master with same slave ip is already present
            $(tblEditStore).each(function (cntStoreItems, storeItem) {
              if (storeItem.id.indexOf('ModbusTCPMaster') > -1) {
                $(storeItem.data).each(function (cntDataItems, dataItem) {
                  if (dataItem.attrGSDname == 'slave_IP_address' && dataItem.attrvalue == deviceIP) {
                    swtIpExists = true;
                    swtAnyIpExisted = true;
                  }
                });
              }
            });

            if (swtIpExists == false) {
              appendedDeviceId = appendDeviceGUI(CONST_MODBUS_MASTER_TO_ADD_AFTER_SCAN, objDropCell, false);
              setDeviceValue(appendedDeviceId, '0', '0', 'slave_IP_address', deviceIP);
            } else {
              alert('Unable to add device - slave IP already exists: ' + deviceIP);
              swtIpExists = false; // reset for next check ...
            }
          });

          // close scan if every requested device has been added; leave it open if there has been a conflict
          if (swtAnyIpExisted == false) {
            $('#dialog_scanDevices').dialog('close');
            alert('Devices have been added ...');
          }
        }, 500); // end timeout
      } else {
        alert('Configuration needs RevPi base device first ...');
      }
    }
  });
}

// Helper function to determine whether there are
// scan results we need to show, depending of the 'Show All' state
function isScanResultsTableVisible() {
  swtRet = false;
  if ($('#chkScanShowAll').prop('checked') == true) {
    // Case 01: if there are ANY result rows (even non-open only), we show them	in result table
    if ($("[id^='trScanResults_']").length > 0) {
      swtRet = true;
    } else {
      swtRet = false;
    }
  } else {
    // Case 02: we only show the result table if it contains at least one open entry
    //if ($('[id^="tdSrOpen_"] [data-open="open"]').length > 0) {
    if ($("[id^='chkSrAdd_']:checked").length > 0) {
      swtRet = true;
    } else {
      swtRet = false;
    }
  }

  return swtRet;
}

function createUserSettingsDialog() {
  $('#dialog_userSettings').dialog({
    width: Math.min(1024, window.innerWidth),
    height: Math.min(768, window.innerHeight),
    modal: true,
    resizable: false,
    title: 'User Settings',
    show: { effect: 'blind', duration: 200 },
    buttons: [
      {
        text: 'Save',
        icons: {
          primary: 'ui-icon-heart',
        },
        click: function () {
          var hasErrors = false;
          var errMessage = '';
          var errControl = '';
          // validate before saving
          $('#dialog_userSettings_msg').hide();

          // setting 01 - Session Timeout
          if ($('#userSetting_01_min').val() == '' || $('#userSetting_01_min').val() == 0) {
            hasErrors = true;
            errMessage = 'ERR: Please enter valid -Custom timeout- (1-999)';
            errControl = 'userSetting_01_min';
          }

          // setting 02 - Auto Export
          $("[id^='userSetting_02_expFilenameWithoutSuffix_']").each(function (index) {
            var posLastDelim = getPosDelimiter($(this).attr('id'), '_', 'LAST');
            var hlpFile = $(this)
              .attr('id')
              .substr(posLastDelim + 1);
            $(this).val($.trim($(this).val())); // trim
            if ($('#userSetting_02_chkExport_' + hlpFile).is(':checked') && $(this).val() == '') {
              hasErrors = true;
              errMessage = 'ERR: Export Filename must not be empty for active export';
              errControl = $(this).attr('id');
            }

            if ($(this).val().indexOf('.') > -1) {
              hasErrors = true;
              errMessage = 'ERR: Please enter filename without suffix (suffix is set by export config)!';
              errControl = $(this).attr('id');
            }

            if ($(this).val().indexOf(' ') > -1) {
              hasErrors = true;
              errMessage = 'ERR: No Blanks allowed in filename ...';
              errControl = $(this).attr('id');
            }
          });

          // setting 03 - Cache
          // currently no validation necessary

          if (hasErrors == true) {
            $('#dialog_userSettings_msg').html(errMessage);
            $('#dialog_userSettings_msg').show();
            $('#' + errControl).focus();
          } else {
            // SAVE

            // check if Timeout Settings have been changed and show info that PiCtory restart is needed!
            if (
              $('#userSetting_01_mode_hid').val() != $('#userSetting_01_mode').val() ||
              $('#userSetting_01_min_hid').val() != $('#userSetting_01_min').val()
            ) {
              createInfoDialog('Info', '<br>' + 'Please restart -PiCtory- for new timeout-settings to take effect', '');
            }

            // setting 01 - Session Timeout
            userSettingsData['01'][2] = $('#userSetting_01_mode').val();
            userSettingsData['01'][3] = $('#userSetting_01_min').val();

            // setting 02 - Auto Export
            userSettingsData['02'].mode = $('#userSetting_02_mode').val();
            if ($('#userSetting_02_mode').val() == 1) {
              userSettingsData['02'].set = []; // clear set array;
              $("[id^='userSetting_02_expJSONfilename_']").each(function (index) {
                var hlpCheckState;
                if ($('#userSetting_02_chkExport_' + $(this).html().replace('.json', '')).is(':checked')) {
                  hlpCheckState = true;
                } else {
                  hlpCheckState = false;
                }

                userSettingsData['02'].set.push([
                  $(this).html(),
                  $('#userSetting_02_expFilenameWithoutSuffix_' + $(this).html().replace('.json', '')).val(),
                  hlpCheckState,
                ]);
              });
            }

            // setting 03 - Cache
            if (userSettingsData.hasOwnProperty('03')) {
              userSettingsData['03'].mode = $('#userSetting_03_mode').val();
            } else {
              // if cache setting does not exist yet, we create it ...
              var hlpJSONObj = {};
              hlpJSONObj.mode = $('#userSetting_03_mode').val();
              userSettingsData['03'] = hlpJSONObj;
            }

            // setting 04 - Autosave
            if (userSettingsData.hasOwnProperty('04')) {
              userSettingsData['04'][2] = $('#userSetting_04_mode').val();
              userSettingsData['04'][3] = $('#userSetting_04_min').val();
            } else {
              // if autosave setting does not exist yet, we create it ...
              var hlpJSONObj = ['Autosave', false, '', ''];
              hlpJSONObj[2] = $('#userSetting_04_mode').val();
              hlpJSONObj[3] = $('#userSetting_04_min').val();
              userSettingsData['04'] = hlpJSONObj;
            }

            // check if Autosave Settings have been changed and if so clear timer and restart autosave interval
            // IMPORTANT: this is done HERE so we can use -getAutosaveMin- function which relies on userSettingsData
            if (
              $('#userSetting_04_mode_hid').val() != $('#userSetting_04_mode').val() ||
              $('#userSetting_04_min_hid').val() != $('#userSetting_04_min').val()
            ) {
              var hlpAutosaveMin = getAutosaveMin();
              window.clearInterval(timerAutoSave); // clear interval
              if (hlpAutosaveMin != 0) {
                // switch on interval if not set to off
                timerAutoSave = setInterval(function () {
                  doAutoSave();
                }, hlpAutosaveMin * 60000); // min --> milliseconds
              }
            }

            $.ajax({
              async: false,
              url:
                'php/saveProject.php?fn=_tmp_userSettings.json' +
                '&RevPiSessionId=' +
                Cookies.get('KUNBUS_RevPiSessionId_' + revPiHostname),
              type: 'POST',
              data: JSON.stringify(userSettingsData),
              processData: false,
              dataType: 'text',
              contentType: 'application/json; charset=utf-8',
              success: function (response) {
                hlpRet = response;
                if (hlpRet == 'PHP_SESSION_INVALID') {
                  // if no valid server session can be found, remove client cookies also
                  Cookies.remove('KUNBUS_RevPiUser_' + revPiHostname);
                  Cookies.remove('KUNBUS_RevPiSessionId_' + revPiHostname);
                  createInfoDialog('Timeout', '<br>' + 'Session expired ...', '');
                }
              },
            });

            AjaxRenameFile("'" + 'USER_SETTINGS' + "'");

            $(this).dialog('close');
          }
        },
      },
      {
        text: 'Cancel',
        icons: {
          primary: 'ui-icon-closethick',
        },
        click: function () {
          $(this).dialog('close');
        },
      },
    ],
  });

  // masking
  $('#userSetting_01_min').mask('000');

  // set dialog events
  //
  // session timeout
  $('#userSetting_01_mode').off();
  $('#userSetting_01_mode').on('change', function (e) {
    $('#dialog_userSettings_msg').hide();
    var currentVal = $('#' + $(this).attr('id')).val();
    if (currentVal == '2') {
      $('#userSetting_01_min').prop('disabled', false);
      $('#userSetting_01_min').focus();
    } else {
      $('#userSetting_01_min').prop('disabled', true);
    }
  });

  // Auto Export
  $('#userSetting_02_mode').off();
  $('#userSetting_02_mode').on('change', function (e) {
    $('#dialog_userSettings_msg').hide();
    var currentVal = $('#' + $(this).attr('id')).val();
    fillUserSettingsDialog(2);
  });

  // Autosave
  $('#userSetting_04_mode').off();
  $('#userSetting_04_mode').on('change', function (e) {
    $('#dialog_userSettings_msg').hide();
    var currentVal = $('#' + $(this).attr('id')).val();
    if (currentVal == '2') {
      $('#userSetting_04_min').prop('disabled', false);
      $('#userSetting_04_min').focus();
    } else {
      $('#userSetting_04_min').prop('disabled', true);
    }
  });

  // fill settings data into dialog controls
  //
  fillUserSettingsDialog(''); // fill all settings

  $('.ui-dialog-titlebar-close').hide(); // hide close x icon
}

function fillUserSettingsDialog(settingsNumber) {
  if (userSettingsData == '') {
    return; // no user settings
  }

  // 01a - Session Timeout
  if (settingsNumber == 1 || settingsNumber == '') {
    $('#userSetting_01_mode').val(userSettingsData['01'][2].toString());
    $('#userSetting_01_mode').trigger('change'); // enable/disable input field according to mode
    $('#userSetting_01_min').val(userSettingsData['01'][3]);
    $('#userSetting_01_mode_opt_std').html(
      $('#userSetting_01_mode_opt_std')
        .html()
        .replace('##CONFIG_TIMEOUT##', configData.misc.sessionExpireMin + ' min.'),
    );

    // set in invisible controls also to detect when settings have changed ...
    $('#userSetting_01_mode_hid').val(userSettingsData['01'][2].toString());
    $('#userSetting_01_min_hid').val(userSettingsData['01'][3]);
  }

  // 01b - Autosave
  if (settingsNumber == 4 || settingsNumber == '') {
    // autosave area may not be present in older versions of PiCtory
    if ('04' in userSettingsData) {
      $('#userSetting_04_mode').val(userSettingsData['04'][2].toString());
      $('#userSetting_04_mode').trigger('change'); // enable/disable input field according to mode
      $('#userSetting_04_min').val(userSettingsData['04'][3]);
      $('#userSetting_04_mode_opt_std').html(
        $('#userSetting_04_mode_opt_std')
          .html()
          .replace('##CONFIG_AUTOSAVE##', CONST_DEFAULT_MINUTES_AUTOSAVE.toString() + ' min.'),
      );

      // set in invisible controls also to detect when settings have changed ...
      $('#userSetting_04_mode_hid').val(userSettingsData['04'][2].toString());
      $('#userSetting_04_min_hid').val(userSettingsData['04'][3]);
    } else {
      // no autosave data in settings yet ... look into global config.json
      if (configData.misc.autoSave == 0 || configData.misc.autoSave == false) {
        // autosave was 0 (minutes) in first versions of PiCtory; was changed to switch 0/1 (meaning 0=false, 1=true) later
        // autosave minutes must now be set in User Settings dialog!
        $('#userSetting_04_mode').val('0');
      } else {
        // autosave was set in global config.json (other than 0) but will be ignored here an set to standard
        $('#userSetting_04_mode').val('1');
      }

      $('#userSetting_04_mode').trigger('change'); // enable/disable input field according to mode

      // Standard autosave interval: CONST_DEFAULT_MINUTES_AUTOSAVE
      $('#userSetting_04_min').val(CONST_DEFAULT_MINUTES_AUTOSAVE.toString());
      $('#userSetting_04_mode_opt_std').html(
        $('#userSetting_04_mode_opt_std')
          .html()
          .replace('##CONFIG_AUTOSAVE##', CONST_DEFAULT_MINUTES_AUTOSAVE.toString() + ' min.'),
      );
    }
  }

  // 02 - Auto Export
  if (settingsNumber == 2 || settingsNumber == '') {
    // 2017/11 - is now being globaly loaded on startup
    //var exportData = AjaxGetJSON(configData.paths.export + "config.json", "OBJ");
    //exportData.files = sortJSON(exportData.files, "order");

    // initialize mode from settings-file when showing dialog!
    if (settingsNumber == '') {
      $('#userSetting_02_mode').val(userSettingsData['02'].mode);
    }

    var arrAutoExportDefault = [];
    var arrAutoExportFilenameNoSuffix = [];
    var arrAutoExportActive = [];
    if ($('#userSetting_02_mode').val() == '0') {
      // use standard settings from global config.json
      if ($.isArray(configData.misc.autoExportDefault)) {
        arrAutoExportDefault = configData.misc.autoExportDefault;
        arrAutoExportFilenameNoSuffix = configData.misc.autoExportFilenameNoSuffix;
      } else {
        arrAutoExportDefault.push(configData.misc.autoExportDefault);
        arrAutoExportFilenameNoSuffix.push(configData.misc.autoExportFilenameNoSuffix);
      }
    } else {
      // use user settings from projects/_userSettings.json
      $.each(userSettingsData['02'].set, function (index, set) {
        arrAutoExportDefault.push(set[0]);
        arrAutoExportFilenameNoSuffix.push(set[1]);
        arrAutoExportActive.push(set[2]);
      });
    }

    var rowTemplate =
      '<tr>' +
      '<td><b>##SCREENNAME##</b></td>' +
      '<td>##DESCRIPTION##</td>' +
      "<td id='userSetting_02_expJSONfilename_##VALUE##'>##FILENAME##</td>" +
      "<td><input type='text' id='userSetting_02_expFilenameWithoutSuffix_##VALUE##' size='15' maxlength='15' value='##VALUE_EXPORTFN_NOSUFFIX##'></td>" +
      "<td align='center'><input type='checkbox' id='userSetting_02_chkExport_##VALUE##' value='##VALUE##' ##DEFAULT##></td>" +
      '</tr>';
    var rowTemplateWork = '';

    $('#tblSettingsExportData tbody').empty();
    $.each(exportData.files, function () {
      if (this.active == true) {
        rowTemplateWork = rowTemplate;
        rowTemplateWork = rowTemplateWork.replace('##SCREENNAME##', this.screenname);
        rowTemplateWork = rowTemplateWork.replace('##DESCRIPTION##', this.description);
        rowTemplateWork = rowTemplateWork.replace('##FILENAME##', this.filename);
        rowTemplateWork = rowTemplateWork.replace(/##VALUE##/g, this.filename.replace('.json', ''));

        if (fileExists('resources/data/patterns/export/' + this.filename)) {
          rowTemplateWork = rowTemplateWork.replace('##MISSING##', '');
        } else {
          rowTemplateWork = rowTemplateWork.replace('##MISSING##', '(FILE MISSING!)');
        }

        var hlpIsInArray = $.inArray(this.filename, arrAutoExportDefault);
        if (hlpIsInArray != -1) {
          if ($('#userSetting_02_mode').val() == 0) {
            rowTemplateWork = rowTemplateWork.replace('##DEFAULT##', 'checked');
          } else {
            if (arrAutoExportActive[hlpIsInArray] == true) {
              rowTemplateWork = rowTemplateWork.replace('##DEFAULT##', 'checked');
            } else {
              rowTemplateWork = rowTemplateWork.replace('##DEFAULT##', '');
            }
          }
          rowTemplateWork = rowTemplateWork.replace(
            '##VALUE_EXPORTFN_NOSUFFIX##',
            arrAutoExportFilenameNoSuffix[hlpIsInArray],
          );
        } else {
          rowTemplateWork = rowTemplateWork.replace('##DEFAULT##', '');
          rowTemplateWork = rowTemplateWork.replace('##VALUE_EXPORTFN_NOSUFFIX##', '');
        }

        // append row to table
        $('#tblSettingsExportData tbody').append(rowTemplateWork);
      }
    });

    //$("#userSetting_02_mode").val(userSettingsData["02"].mode);
    if ($('#userSetting_02_mode').val() == '0') {
      $('#userSettings_02_title01').html('Standard settings:');
      $("[id^='userSetting_02_expFilenameWithoutSuffix_']").prop('disabled', true);
      $("[id^='userSetting_02_chkExport_']").prop('disabled', true);
    } else {
      $('#userSettings_02_title01').html('Custom settings:');
      $("[id^='userSetting_02_expFilenameWithoutSuffix_']").prop('disabled', false);
      $("[id^='userSetting_02_chkExport_']").prop('disabled', false);
    }
  }

  // 03 - Cache
  if (settingsNumber == 3 || settingsNumber == '') {
    // IMPORTANT: 	cache setting was added without updating
    //				_usersettings.json file - so this property may not exist
    //				the first time we open the settings dialog after update
    //				If setting does NOT exist yet we do nothing - cache mode
    //				select defaults to '0' (On) in this case
    if (userSettingsData.hasOwnProperty('03')) {
      $('#userSetting_03_mode').val(userSettingsData['03'].mode);
    }
  }
}

function createProjectDialog(mode) {
  $('#dialog_project').dialog({
    width: 550,
    modal: true,
    title: mode == 'OPEN' ? 'Open Project' : 'Save Project',
    show: { effect: 'blind', duration: 200 },
    buttons: [
      {
        text: 'Ok',
        id: 'okDialogSaveProject',
        icons: {
          primary: 'ui-icon-heart',
        },
        click: function () {
          $('#txtInputFilename').val($.trim($('#txtInputFilename').val()));

          if (
            $('#txtInputFilename').val().indexOf('[') > -1 ||
            $('#txtInputFilename').val().indexOf(']') > -1 ||
            $('#txtInputFilename').val().indexOf(' ') > -1
          ) {
            $('#lblSaveProjectMessage').html('filename has invalid characters ...');
            return;
          }

          if ($('#txtInputFilename').val().substr(0, 1) == '_') {
            $('#lblSaveProjectMessage').html("filename must not start with '_'");
            return;
          }

          if (!fileExists(configData.paths.projects + $('#txtInputFilename').val() + '.rsc')) {
            currentExportTS = getCurrentTS('YmdHis');
            var retDoExport = doExport('project.json', $.trim($('#txtInputFilename').val()) + '.rsc');
            if (retDoExport != 'OK') {
              $('#lblSaveProjectMessage').html(retDoExport);
            } else {
              // do autoExport
              if (typeof configData.misc.autoExport != 'undefined' && configData.misc.autoExport == true) {
                var arrAutoExportDefault = [];
                var arrAutoExportFilenameNoSuffix = [];
                var arrGetActiveAutoExport = getActiveAutoExport();
                arrAutoExportDefault = arrGetActiveAutoExport[0];
                arrAutoExportFilenameNoSuffix = arrGetActiveAutoExport[1];

                $.each(arrAutoExportDefault, function (index, filename) {
                  var exportConfigData = getExportConfigData(filename);
                  var retDoExport = doExport(
                    filename,
                    '../export/' + arrAutoExportFilenameNoSuffix[index] + '.' + exportConfigData.filetype,
                    true,
                    false,
                  );
                });
              }

              setProjectInfo(
                $('#txtInputFilename').val(),
                getProjectFileLastSaved($('#txtInputFilename').val(), 'd.m.Y H:i:s'),
              );
              currentProjectFilename = $('#txtInputFilename').val();
              $(this).dialog('close');
              swtIsDirty = false;

              createInfoDialog('Info', '<br>Project saved...', '{"autoClose":1000}');
            }
          } else {
            $('#lblSaveProjectMessage').html(
              'project ' + $('#txtInputFilename').val() + ' already exists - use override button to replace ...',
            );
            $('#txtInputFilename').val('');
            $('#txtInputFilename').trigger('keyup');
          }
        },
      },
      {
        text: 'Cancel',
        id: 'cancelDialogSaveProject',
        icons: {
          primary: 'ui-icon-closethick',
        },
        click: function () {
          $(this).dialog('close');
        },
      },
    ],
  });

  $('.ui-dialog-titlebar-close').hide(); // hide close x icon
  $('#lblSaveProjectMessage').html(''); // reset error message
}

// Die ##LANG_MOUSE## sitzt im ##LANG_HOUSE## xxx
// ERRORTEXT and TRANSLATION functions

function TextTranslate(langObjJSON, strCurrentLang, strToTranslate) {
  var posTargetStart;
  var posTargetEnd;
  var hlpReplString = '';

  // loop over string to translate and find targets
  posTargetStart = strToTranslate.indexOf('##LANG_');
  while (posTargetStart > -1) {
    posTargetEnd = strToTranslate.indexOf('##', posTargetStart + 1);
    hlpReplString = strToTranslate.substr(posTargetStart, posTargetEnd + 2 - posTargetStart);
    hlpReplString = hlpReplString.replace('##LANG_', '');
    hlpReplString = hlpReplString.replace('##', '');

    if (typeof langObjJSON[strCurrentLang][hlpReplString] != 'undefined') {
      strToTranslate = strToTranslate.replace(
        '##LANG_' + hlpReplString + '##',
        langObjJSON[strCurrentLang][hlpReplString],
      );
    } else {
      strToTranslate = strToTranslate.replace(
        '##LANG_' + hlpReplString + '##',
        '=' + GetErrorText('ERR_LANG_01', strCurrentLang, 'short') + hlpReplString + '=',
      );
    }
    posTargetStart = strToTranslate.indexOf('##LANG_');
  }

  return strToTranslate;
}

function GetErrorText(idErrorText, lang, size) {
  var hlpErrorsJSON = AjaxGetJSON('resources/data/validation/errors.json', 'OBJ');
  if (typeof hlpErrorsJSON.errors[0][lang][idErrorText] != 'undefined') {
    return hlpErrorsJSON.errors[0][lang][idErrorText][size];
  } else {
    return idErrorText;
  }
}

function replaceSpecialChars(inpString) {
  var retString = inpString;
  retString = retString.replace(/ /g, '_'); //replace blank with underscore

  return retString;
}

function handleEscStr(mode, inpStr) {
  var retString = 'ERR_NO_ESC';
  var esc = [[',', '*!*']];

  $.each(esc, function () {
    if (mode == 'ESC' && inpStr == $(this)[0]) {
      retString = $(this)[1];
    }
    if (mode == 'UN_ESC' && inpStr == $(this)[1]) {
      retString = $(this)[0];
    }
  });

  return retString;
}

function getRandomInt(min, max) {
  return Math.floor(Math.random() * (max - min + 1)) + min;
}

function checkSession(revPiHostname) {
  return '' + Cookies.get('KUNBUS_RevPiSessionId_' + revPiHostname) !== 'undefined';
}

function checkJSONdatatype(objJSON, expectedType) {
  if ($.type(objJSON) == expectedType) {
    return true;
  } else {
    return false;
  }
}

function refreshLoginCookies(expireMin, revPiHostname) {
  if ('' + Cookies.get('KUNBUS_RevPiSessionId_' + revPiHostname) !== 'undefined') {
    var cookieExpire = new Date(new Date().getTime() + expireMin * 60 * 1000);
    Cookies.set('KUNBUS_RevPiUser_' + revPiHostname, Cookies.get('KUNBUS_RevPiUser_' + revPiHostname), {
      expires: cookieExpire,
      secure: true
    });
    Cookies.set('KUNBUS_RevPiSessionId_' + revPiHostname, Cookies.get('KUNBUS_RevPiSessionId_' + revPiHostname), {
      expires: cookieExpire,
      secure: true
    });
  }
}

function getURLParameter(name) {
  return decodeURI((RegExp(name + '=' + '(.+?)(&|$)').exec(location.search) || [, null])[1]);
}

function checkServerHEADMethod() {
  var requestType = 'HEAD';

  $.ajax({
    url: 'resources/js/common.js',
    type: requestType,
    async: false,
    error: function () {
      requestType = 'GET';
    },
  });

  return requestType;
}

function isIPaddressValid(ipaddress) {
  if (
    /^(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$/.test(
      ipaddress,
    )
  ) {
    return true;
  }

  return false;
}

var table_crc =
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
var arr_crc = table_crc.split(' ').map(function (s) {
  return parseInt(s, 16);
});
function b_crc32(str) {
  var crc = -1;
  for (var i = 0, iTop = str.length; i < iTop; i++) {
    crc = (crc >>> 8) ^ arr_crc[(crc ^ str.charCodeAt(i)) & 0xff];
  }
  return (crc ^ -1) >>> 0;
}

function getNextScanRange(ipRange, count) {
  var retRangeString = '';
  var startArrIndex = 0;

  startArrIndex = (count - 1) * CONST_SCAN_RANGE_SIZE;
  for (var i = startArrIndex; i < CONST_SCAN_RANGE_SIZE + startArrIndex; i++) {
    if (ipRange[i] !== undefined) {
      retRangeString = retRangeString + '"' + ipRange[i] + '"' + ',';
    } else {
      break;
    }
  }

  retRangeString = killLastDelimiter(retRangeString, ',');
  return retRangeString;
}

var cntLoop = 5;
function loop() {
  setTimeout(function () {
    // Your logic here
    console.log('seconds elapsed = ' + Math.round(+new Date() / 1000));
    cntLoop--;
    if (cntLoop > 0) {
      loop();
    }
  }, 2000);
}

function testGetIPRange(startAddr, EndAddr) {
  for (var i = 0x0a0a0100; i < 0x0a0a0a0a; i++) {
    var oc4 = (i >> 24) & 0xff;
    var oc3 = (i >> 16) & 0xff;
    var oc2 = (i >> 8) & 0xff;
    var oc1 = i & 0xff;

    $('#output').append(oc4 + '.' + oc3 + '.' + oc2 + '.' + oc1 + '<br>');
  }
}
