// 	IMPORTANT: 
//	global variables from main.js are available here; 
// 	direct access to tblEditStore etc. is possible
// 	parameters passed on instantiation are for convencience only! 

var modifyAttributes = function(idDevice, inpVariant, outVariant){
	this.idDevice = idDevice;
	this.inpVariant = inpVariant;	
	this.outVariant = outVariant;
	this.baseDeviceHelper = "";
};
modifyAttributes.prototype = {
	modify: function() {
		var me = this;
		var retVal = "NO_MOD"; // set default to 'not modified'
		var tblEditEntry = handleTableData("tblEdit", "device_" + me.idDevice + "," + me.inpVariant + "," + this.outVariant, "GETENTRY");
		var baseDeviceId = getBaseDeviceId();
		var tmp_devicePath = "";
		
		//if (swtDEBUG == true) {
			//debugger;
		//}
	
		// 
		if ((baseDeviceId.indexOf('Connect') > -1)) {
			me.baseDeviceHelper = "CONNECT";
		}
		if ((baseDeviceId.indexOf('Compact') > -1)) {
			me.baseDeviceHelper = "COMPACT";
		}
		if ((baseDeviceId.indexOf('Flat') > -1)) {
			me.baseDeviceHelper = "FLAT";
		}
		
	
		$.each(tblEditEntry.data, function(cntDataEntries, dataEntry) {	
		
			// MOD01: 	change -device_path- value for 'Connect','Compact' and 'Flat' base devices from default value in RAP-file
			//		
			//			RULE 01: 	if the first ModbusRTU device is being added to the configuration of a 'Connect' 
			//						or 'Compact' Base-device, its -device_path- value is set to '/dev/ttyRS485'
            //                      For 'Flat', first is set to '/dev/ttyRS485_0' and  second device to '/dev/ttyRS485_1'			
			//
			//			RULE 02: 	if a ModbusRTU device already has -device_path- set to '/dev/ttyRS485' (in case of connect or Compact Base-devices)
			//                      or '/dev/ttyRS485_1' (in case of Flat Base-device),
			//						following ModbusRTU devices geht numbered '/dev/ttyUSB?' values beginning
			//						with '/dev/ttyUSB2' (for Connect Base-devices),'/dev/ttyUSB0'
			//						(for Compact Base-devices) and with '/dev/ttyUSB1' (for Flat Base-devices)
			//
			//			RULE 03: 	if ModbusRTU devices have been removed, newly added devices will fill 
			//						the gaps in their '/dev/ttyUSB?' numbering
			//
			//			RULE 04:	if the ModbusRTU device which had -device_path- set to '/dev/ttyRS485' was
			//						removed, the next added ModbusRTU device will again geht '/dev/ttyRS485'
			//
			//			RULE 05:	All devices keep their positions in -PiCtory- canvas; changing their
			//						-device_path- values has no influence on their positions
			//			
			if ((me.baseDeviceHelper == "CONNECT") || (me.baseDeviceHelper == "COMPACT")|| (me.baseDeviceHelper == "FLAT")){
				if(dataEntry.attrname.startsWith('device_path')) {				
					tmp_devicePath = me.getNextDevicePathString();	
					// set value only if device_path has been changed from .RAP-file default!	
					if (tmp_devicePath != '/dev/ttyUSB0') {
						dataEntry.attrvalue = tmp_devicePath;
						$("input[id^=tblEdit_attrvalue]:eq(" + cntDataEntries + ")").val(tmp_devicePath);
						dataEntry.attrGSDcomment = "INFO: value modified to adapt base device type";
						$("input[id^=tblEdit_attrGSDcomment]:eq(" + cntDataEntries + ")").val("INFO: value modified to adapt base device type");
					}
					
					retVal = "OK";
				}
			}
		});

		return retVal;
	},
	getNextDevicePathString: function() {
		var me = this;
		var retString = ''; 
		var retFindDeviceValue;
		var startUSB;	
		var cntModbus = countDevices('device_ModbusRTU');
		
		if ((me.baseDeviceHelper == "CONNECT") || (me.baseDeviceHelper == "FLAT")){
			startUSB = 1;
		}		
		if(me.baseDeviceHelper == "COMPACT") {
			startUSB = 0;
		}	
		
		if ((me.baseDeviceHelper == "CONNECT") || (me.baseDeviceHelper == "COMPACT")){
			//RULE 01 - check if '/dev/ttyRS485' already set in a ModbusRTU device
			retFindDeviceValue = findDeviceValue('ModbusRTU','device_path','/dev/ttyRS485');
			if (retFindDeviceValue.length > 0) {
				retFindDeviceValue = findDeviceValue('ModbusRTU','device_path','/dev/ttyUSB' + startUSB);
				if (retFindDeviceValue.length == 1) {
					retString = '/dev/ttyUSB' + startUSB;
				}
				else {
					for (cntUSB = startUSB + 1; cntUSB < (cntModbus + startUSB); cntUSB++ ) {				
						retFindDeviceValue = findDeviceValue('ModbusRTU','device_path','/dev/ttyUSB' + cntUSB);
						if (retFindDeviceValue.length == 0) {
							retString = '/dev/ttyUSB' + (cntUSB);
							break; // out of for loop
						}
					}
				}
			} else {
				retString = '/dev/ttyRS485';
			}		
		}
						
		
		if(me.baseDeviceHelper == "FLAT") {
			//RULE 01 - check if '/dev/ttyRS485_1' already set in a ModbusRTU device
			retFindDeviceValue = findDeviceValue('ModbusRTU','device_path','/dev/ttyRS485-1');
			retFindFirstRS485Value = findDeviceValue('ModbusRTU','device_path','/dev/ttyRS485-0');
			if (retFindDeviceValue.length > 0) {	
				for (cntUSB = startUSB ; cntUSB < (cntModbus + startUSB); cntUSB++ ) {				
					retFindDeviceValue = findDeviceValue('ModbusRTU','device_path','/dev/ttyUSB' + cntUSB);
					if (retFindDeviceValue.length == 0) {
						retString = '/dev/ttyUSB' + (cntUSB);
						break; // out of for loop
					}
				}
			} else {				
					if (retFindFirstRS485Value.length > 0) {
						retString = '/dev/ttyRS485-1';
					} else{
						retString = '/dev/ttyRS485-0';
					}
				}
			
			if (!retFindFirstRS485Value.length > 0) {
				retString = '/dev/ttyRS485-0';
			} 			
		}
				
		return retString;
	}
};
