<?php

$json_params = file_get_contents('php://input');
$decoded_params = json_decode($json_params);

// do nothing if no valid session exists
if (!isset($_SESSION['RevPiSessionId']) || ($decoded_params->RevPiSessionId != $_SESSION['RevPiSessionId'])) {
	echo "PHP_SESSION_INVALID";
	exit;
}

if ($decoded_params->mode == "GET_IFCONFIGINFO") {
	echo getIfconfigInfo();
}

if ($decoded_params->mode == "SCAN_IPRANGE") {
	echo portScan($decoded_params->ipRange,array($decoded_params->port));
}

if ($decoded_params->mode == "GET_IPRANGE") {
	$cidr = $decoded_params->startIP . '/' . mask2cidr($decoded_params->netMask);
	echo json_encode(getEachIpInRange ( $cidr));
}

// we force exit here; all calls must be done via modes
exit;

// TEST CALLS

//getNetMask();
//echo getOSinfo("##VERSION##<br>##PRETTY_NAME##<br>##VERSION##");
//echo getIfconfigInfo();
//test();
//echo getCountAvailableHosts("255.255.255.240");


function portScan($hosts,$tcpPorts) {

	//$hosts = array("192.168.1.1","192.168.1.2");
	//$tcpPorts = array(21, 22, 23, 25, 53, 79, 80, 110, 115, 135, 139, 143, 194, 389, 443, 445, 465, 1433, 1723, 3306, 3389, 5632, 5900, 6112, 8080);

	$timeoutSeconds = 0.3;
	$result = array();
	foreach($hosts as $host)
	{
		foreach($tcpPorts as $port)
		{
			$fp = fsockopen($host, $port, $errno, $errstr, $timeoutSeconds);
			if (!$fp) {
				$item = array(
					'host' => $host,
					'port' => $port,
					'open' => false,
					'message' => "$errstr ($errno)"
					);

				array_push($result, $item);
			} else {
				$item = array(
					'host' => $host,
					'port' => $port,
					'open' => true,
					'message' => ''
					);

				array_push($result, $item);

				fclose($fp);
			}
		}
	}

	SendToBrowserAsJson($result);
}

function SendToBrowserAsJson($obj)
{
	$raw = json_encode($obj/*, JSON_PRETTY_PRINT*/);
	$le = json_last_error();
	if( $le>0 )
	{
		if($le==JSON_ERROR_UTF8)
		{
			$raw = json_encode(Utf8ize($obj)/*, JSON_PRETTY_PRINT*/);
			$le = json_last_error();
		}

		if( $le>0 )
		{
			$leReadable = translateJsonLastError($le);
			$msg = "JSON last error: $le ($leReadable).";

			error_log($msg);

			throw new Exception($msg);
		}
	}

	ob_clean();
	header('Content-type: application/json');
	echo($raw);
}

function Utf8ize($d)
{
	if (is_array($d))
		foreach ($d as $k => $v)
			$d[$k] = Utf8ize($v);

	elseif(is_object($d))
		foreach ($d as $k => $v)
			$d->$k = Utf8ize($v);

	else
		return utf8_encode($d);

	return $d;
}

function translateJsonLastError($le)
{
	switch($le)
	{
		case JSON_ERROR_NONE:
			return "JSON_ERROR_NONE - Kein Fehler aufgetreten.";
		case JSON_ERROR_DEPTH:
			return "JSON_ERROR_DEPTH - 	Die maximale Stacktiefe wurde überschritten.";
		case JSON_ERROR_STATE_MISMATCH:
			return "JSON_ERROR_STATE_MISMATCH - Ungültiges oder missgestaltetes JSON.";
		case JSON_ERROR_CTRL_CHAR:
			return "JSON_ERROR_CTRL_CHAR - Steuerzeichenfehler, möglicherweise unkorrekt kodiert.";
		case JSON_ERROR_SYNTAX:
			return "JSON_ERROR_SYNTAX - Syntaxfehler.";
		case JSON_ERROR_UTF8:
			return "JSON_ERROR_UTF8 - Missgestaltete UTF-8-Zeichen, möglicherweise fehlerhaft kodiert.";
		case JSON_ERROR_RECURSION:
			return "JSON_ERROR_RECURSION - Eine oder mehrere rekursive Referenzen im zu kodierenden Wert.";
		case JSON_ERROR_INF_OR_NAN:
			return "JSON_ERROR_INF_OR_NAN - Eine oder mehrere NAN- oder INF-Werte im zu kodierenden Wert.";
		case JSON_ERROR_UNSUPPORTED_TYPE:
			return "JSON_ERROR_UNSUPPORTED_TYPE - Ein Wert eines Typs, der nicht kodiert werden kann, wurde übergeben.";
		default:
			return "Unbekannt $le";
	}
}

/*
IMPORTANT:
getOSinfo() works with os info output of following format (example):

PRETTY_NAME="Raspbian GNU/Linux 9 (stretch)"
NAME="Raspbian GNU/Linux"
VERSION_ID="9"
VERSION="9 (stretch)"
ID=raspbian
ID_LIKE=debian
HOME_URL="http://www.raspbian.org/"
SUPPORT_URL="http://www.raspbian.org/RaspbianForums"
BUG_REPORT_URL="http://www.raspbian.org/RaspbianBugs"
*/
function getOSinfo($replString) {
	$retString = $replString;
	$strOsr = trim(file_get_contents('os-release.txt'));
	$arrOsr = preg_split('/\r\n|\r|\n/', $strOsr); //explode(PHP_EOL,$strOsr);
	foreach ($arrOsr as $value) {

		$hlpSplit = explode("=",$value);
		$retString = str_replace("##". $hlpSplit[0] ."##",str_replace('"','',$hlpSplit[1]),$retString);
	}

	return $retString;
}

/*
IMPORTANT:
getIfconfigInfo() works with IFconfig-Output of following format (example):

eth0: flags=4163<UP,BROADCAST,RUNNING,MULTICAST>  mtu 1500
        inet 192.168.1.83  netmask 255.255.255.0  broadcast 192.168.1.255
        inet6 fe80::c14f:4445:5fbb:48ba  prefixlen 64  scopeid 0x20<link>
        ether c8:3e:a7:00:0e:e3  txqueuelen 1000  (Ethernet)
        RX packets 389  bytes 27635 (26.9 KiB)
        RX errors 0  dropped 0  overruns 0  frame 0
        TX packets 5282  bytes 296882 (289.9 KiB)
        TX errors 0  dropped 0 overruns 0  carrier 0  collisions 0

lo: flags=73<UP,LOOPBACK,RUNNING>  mtu 65536
        inet 127.0.0.1  netmask 255.0.0.0
        inet6 ::1  prefixlen 128  scopeid 0x10<host>
        loop  txqueuelen 1  (Local Loopback)
        RX packets 100178  bytes 8228280 (7.8 MiB)
        RX errors 0  dropped 0  overruns 0  frame 0
        TX packets 100178  bytes 8228280 (7.8 MiB)
        TX errors 0  dropped 0 overruns 0  carrier 0  collisions 0

MODIFY FUNcTION (MAINLY IN STEP02) IF THIS FORMAT CHANGES!!

*/
function getIfconfigInfo() {
	$strRetJSON = "[##RET_FINAL##]";
	$allIfData = "";
	$tmplIfData = '{"ifname":"##IFNAME##","ipaddr":"##IPADDR##","netmask":"##NETMASK##"}';

	// STEP01: split full ifconfig output at double linebreak (split interfaces)
	// write to projects dir since there is write permission
	exec('ifconfig > ../projects/_ifconfigout.txt',$res);
	$arrIfconfigL01 = explode("\n\n",trim(file_get_contents('../projects/_ifconfigout.txt')));

	// STEP02: loop over array; find entry starting with 'flags'
	foreach ($arrIfconfigL01 as $valueL01) {
		$i=0;
		// preg_replace replaces multiple blanks with single blank to get rid of not needed empty array entries
		$arrIfconfigL02 = explode(" ",preg_replace('!\s+!', ' ', $valueL01));
		foreach ($arrIfconfigL02 as $valueL02) {
			//##IFNAME##
			if (startsWith($valueL02,"flags")) {
				$workIfData = $tmplIfData;
				$workIfData = str_replace("##IFNAME##",$arrIfconfigL02[$i-1],$workIfData);
			}
			//##IPADDR##
			if ($valueL02 == "inet") {
				$workIfData = str_replace("##IPADDR##",$arrIfconfigL02[$i+1],$workIfData);
			}
			//##NETMASK##
			if ($valueL02 == "netmask") {
				$workIfData = str_replace("##NETMASK##",$arrIfconfigL02[$i+1],$workIfData);
			}

			$i++;
		}

		//IMPORTANT:
		//interfaces which are 'down', e.g. 'pileft' interface with no devices attached
		//need not be offered for scanning; they have replacement target ##IPADDR## still in place
		if (strpos($workIfData,'##IPADDR##') == false) {
			$allIfData = $allIfData . $workIfData . ",";
		}
	}

	$strRetJSON = str_replace("##RET_FINAL##",killLastDelim($allIfData,","),$strRetJSON);
	return $strRetJSON;
}

function getIp()
{
	exec('/sbin/ifconfig', $resultArray);
	$result = implode(",", $resultArray);

	$ip = preg_match('/eth0.*?inet\saddr:([\d]{1,3}\.[\d]{1,3}\.[\d]{1,3}\.[\d]{1,3})\s/', $result, $matches);

	return isset($matches[1])?$matches[1]:false;
}


// Helper functions
function killLastDelim($strInp,$strDelim) {
	$strRet = $strInp;
	if (endsWith($strRet,$strDelim) == true) {
		$strRet = substr($strRet,0,strlen($strRet)-strlen($strDelim));
	}

	return $strRet;
}

function getCountAvailableHosts($strNetmask) {

	$allBits = "";
	$arrIPparts = explode(".",$strNetmask);
	foreach ($arrIPparts as $IPpart) {
		//echoBR($IPpart);
		$allBits = $allBits . sprintf( "%08d", decbin(intval($IPpart)));
	}

	return pow(2,substr_count ( $allBits,"0"))-2; // subtract 2 since 0 and 255 are not allowed
}

function getIpRange(  $cidr) {

    list($ip, $mask) = explode('/', $cidr);

    $maskBinStr =str_repeat("1", $mask ) . str_repeat("0", 32-$mask );      //net mask binary string
    $inverseMaskBinStr = str_repeat("0", $mask ) . str_repeat("1",  32-$mask ); //inverse mask

    $ipLong = ip2long( $ip );
    $ipMaskLong = bindec( $maskBinStr );
    $inverseIpMaskLong = bindec( $inverseMaskBinStr );
    $netWork = $ipLong & $ipMaskLong;

    $start = $netWork+1;//ignore network ID(eg: 192.168.1.0)

    $end = ($netWork | $inverseIpMaskLong) -1 ; //ignore brocast IP(eg: 192.168.1.255)
    return array('firstIP' => $start, 'lastIP' => $end );
}

function getEachIpInRange ( $cidr) {
    $ips = array();
    $range = getIpRange($cidr);
    for ($ip = $range['firstIP']; $ip <= $range['lastIP']; $ip++) {
        $ips[] = long2ip($ip);
    }
    return $ips;
}

function mask2cidr($mask){
     $long = ip2long($mask);
     $base = ip2long('255.255.255.255');
     return 32-log(($long ^ $base)+1,2);
}

function startsWith($haystack, $needle)
{
     $length = strlen($needle);
     return (substr($haystack, 0, $length) === $needle);
}

function endsWith($haystack, $needle)
{
    $length = strlen($needle);
    if ($length == 0) {
        return true;
    }

    return (substr($haystack, -$length) === $needle);
}

function echoBR($string) {
	echo $string . "<br>";
}

function test() {
	$arrTest = explode("\n\n",file_get_contents('ifconfigout.txt'));

	foreach ($arrTest as $value) {
		echoBR($value);
		echoBR("XXX");
	}
}

?>
