<?php
	session_start();

	if (isset($_SESSION['RevPiSessionId']) && ($_GET['RevPiSessionId'] == $_SESSION['RevPiSessionId'])) {
		chdir("../projects/");

		$fnFilePath = $_GET['fn'];
		$fnFilePathParts = pathinfo($fnFilePath);
		$fnFileExtension = $fnFilePathParts['extension'];
		$arrPathname = explode("/", $fnFilePath);
		$allowedExtensions = array("json", "rsc", "global", "txt", "seq");

		if (in_array($fnFileExtension, $allowedExtensions) === FALSE) {
			http_response_code(400);
			exit;
		}

		if (count($arrPathname) == 1 || (count($arrPathname) == 3 && ($arrPathname[0] == ".." && $arrPathname[1] == "export"))) {
			if (strpos($_GET['fn'],".json") === FALSE) {
				// url: "php/saveProject.php?fn=" + filenameExportFile...in main.js
				$text_data = file_get_contents('php://input');
				if (strlen($text_data) > 0) {

							file_put_contents('_tmpSave', $text_data);

							if ($_GET['fixupConfig'] == "true" && isValidJSON($text_data)) {
								$cmd = "pictory_configcheck -m -l pictory_configcheck.log -c _tmpSave";
								exec($cmd);
							}

							rename ( '_tmpSave' , $fnFilePath);

							echo "OK";
				} else {
					echo "Fail";
				}
			}
			else {
				//url: "saveProject.php?fn=_tmp_userSettings.json"... in common.js
				$json_data = file_get_contents('php://input');
				if (strlen($json_data) > 0 && isValidJSON($json_data)) {

							file_put_contents('_tmpSave', $json_data);
							rename ( '_tmpSave' , $fnFilePath);

							echo "OK";
				} else {
					echo "Fail";
				}
			}
		}
	} else {
		echo "PHP_SESSION_INVALID";
	}

	function isValidJSON($str) {
		json_decode($str);
		return json_last_error() == JSON_ERROR_NONE;
	}
?>
