<!--
SPDX-FileCopyrightText: 2023 KUNBUS GmbH

SPDX-License-Identifier: GPL-2.0-or-later
-->

# MQTT Revolution Pi client

Wie jedes andere Modul wird auch der MQTT Client in PiCtory konfiguriert.
Einfach im Gerätekatalog auf der linken Seite das "MQTT Client" Modul mit
der Maus in die bestehende PiCtory-Konfiguration hineinziehen.

Der MQTT Client sendet die Werte aller verknüpften IOs der PiCtory Konfiguration
an den MQTT Broker, unter folgenden Topics:

- Topic: {Base_Topic}/io/{IO_Name}
- Payload: Wert des IO

Dabei kann der {Base_Topic} frei über die MEM Werte in PiCtory konfiguriert
werden. Der {IO_Name} ist der symbolische Name der IOs, welche ebenfalls in den
jeweiligen Modulen im Value-Editor von PiCtory eingestellt werden.

Der Payload (Der Wert, der auf dem Topic gesendet wird) ist bei allen IOs ein
Zahlenwert. Dies ist speziell bei IOs des Typen BOOL zu beachtet, die jeweils
eine `0` für inaktiv (False) oder `1` für aktiv (True) enthalten.

![PiCtory configuration](docs/images/pictory.png)

> PiCtory kann von einem Browser durch Eingabe
> von 'https://revpi000000.local:41443' (000000 gegen die Seriennummer auf
> dem Gehäuse austauschen) erreicht werden.
>
> ![Serial number](docs/images/serialnumber.png)
>
> Weitere
> Informationen [bei Kunbus](https://revolutionpi.com/tutorials/was-ist-pictory-2/pictory)

## Installation

Sollten das Paket auf dem Revolution Pi noch nicht vorinstalliert sein, kann
es ganz einfach über APT nachinstalliert werden. Das Paket ist ab dem
Betriebssystem "Debian Bullseye" verfügbar.

```
apt update
apt install mqtt-revpi-client
```

Nach der Installation steht das MQTT Client Modul im PiCtory Katalog zur
Verfügung.

> Achtung: Es muss mindestens PiCtory in der Version 2.3.0 vorliegen! Für die
> Aktualisierung kann `apt upgrade` verwendet werden.

## Überblick der INP-/OUT-Werte

Das MQTT Client Device verfügt über einen Eingang und einen Ausgang.

### Eingang "Client_status"

Der Eingang zeigt über einen Wert den Status der Verbindung zum MQTT Broker an.
Dieser kann über eine Steuerungssoftware oder piTest ausgelesen werden. Die
möglichen Statuscodes sind hier aufgelistet:

| Status | Beschreibung                                                                                                                                                                                                                                       |
|--------|----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| 0      | Der Client ist erfolgreich mit dem MQTT Broker verbunden                                                                                                                                                                                           |
| 1      | Verbindung nicht möglich, da eine falsche MQTT Protokollversion verwendet wird. Der MQTT RevPi Client arbeitet mit dem MQTT Protokoll in Version 3.1.1. Diese Version muss vom MQTT Broker unterstützt werden.                                     |
| 2      | Die Client ID ist nicht gültig. Der Revolution Pi erzeugt vor der Verbindung eine zufällig generierte, gültige ID, mit der er sich beim Broker anmeldet. Dieser Zustand kann nur eintreffen, wenn auf dem Broker bereits eine solche ID existiert. |
| 3      | Der Server ist nicht verfügbar. Eventuell liegt ein interner Fehler beim Broker vor.                                                                                                                                                               |
| 4      | Die Anmeldedaten, bestehend aus Benutzername und Password sind nicht gültig.                                                                                                                                                                       |
| 5      | Die Anmeldedaten sind gültig, aber der MQTT Client hat keine Berechtigung auf bestimmte Funktionen oder Topics zuzugreifen.                                                                                                                        |
| 255    | Der Client ist nicht mit dem Broker verbunden und versucht es aktuell auch nicht.                                                                                                                                                                  |

### Ausgang "Disconnect_client"

Über den Ausgang kann gesteuert werden, ob der MQTT Client sich mit dem Broker
verbinden soll. Bei einem Wert von "0" (Standardwert) wird sofort versucht eine
Verbindung zum MQTT Broker herzustellen. Sollte dies nicht erwünscht sein und
der MQTT Client Softwaregesteuert einen ersten Verbindungsversuch durchführen
sollen, kann dieser Wert auf "1" gestellt werden. Es wird dann erst ein
Verbindungsversuch unternommen, wenn der Wert auf "0" gesetzt wird (Entweder
über ein Steuerprogramm oder piTest).
Ist der MQTT Client bereits verbunden und der Wert wird von "0" auf "1" gesetzt,
trennt der MQTT Client die Verbindung zum Broker. Diese wird erst wieder
aufgebaut, wenn der Wert "0" ist.

## Überblick der MEM-Werte

Über die Memories (MEM) Werte im "Value Editor" von PiCtory werden alle
Einstellungen des MQTT Clients vorgenommen.

- Broker address: Adresse des Brokers, mit dem sich der MQTT Client verbinden
  soll.
- Port: Port des Brokers, mit dem sich der MQTT Client verbindet.
- Base topic: Der Beginn eines jeden Topics, welches den MQTT Client Topics
  vorangestellt wird.
  Damit können die IOs auf dem Broker logisch geordnet werden.
- [Shared_IOs](docs/images/shared_ios.png):
  Dank der neuen Technik "Shared IOs" können bestehende Ein- und Ausgänge
  von anderen Modulen direkt mit dem MQTT Client verknüpft werden. Dabei
  kann gewählt, ob nur exportierte Ein- und Ausgänge verwendet werden sollen
  oder alle verfügbaren.
- [Sending_behavior](docs/images/sending_behavior.png):
  Dieser Wert bestimmt die Art der Übermittlung der IO-Werte an den Broker.
  Dabei gibt es verschiedene Zeitwerte für die zyklische Übermittlung zur
  Wahl. Die Option "Send on change" sendet unmittelbar nach Wertänderung
  eines IOs den neuen Wert an den Broker.
- [Output_mode](docs/images/output_mode.png):
  Die verknüpften Ausgänge werden immer, gemäß dem "Sending behavior"
  gesendet. Wird der "Output mode" auf "Read and write" gesetzt, abonniert
  der MQTT Client den Topic `[[base_topic]]/set/[[io_name]]`. Wird über das
  Topic von einem anderen Client ein Wert im Payload gesendet, schreibt der
  MQTT Client diesen Wert in den angegebenen Ausgang.
- User name: Benutzername zur Anmeldung auf dem MQTT Broker.
- Password: Passwort für den angegebenen Benutzer zur Anmeldung auf dem Broker.
- [Use_TLS_encryption](docs/images/use_tls_encryption.png):
  Gibt an, ob die TLS Verschlüsselung für die Clientverbindung verwendet
  werden soll. Der Standardport für verschlüsseltes MQTT ist 8883, welcher in
  den Porteinstellungen geändert werden muss.
- Replace_IO_file:
  Siehe [strukturierte Daten über `replace_io_file`-Datei](#strukturierte-daten-über-replaceiofile-datei).

## Strukturierte Daten über `replace_io_file`-Datei

Die verwendete Bibliothek RevPiModIO2 bringt, für virtuelle Devices, die
Funktion für IO-Ersetzung mit. Damit können die reinen BYTEs / WORDs von den
virtuellen Devices in passende Datentypen umgewandelt werden. Müssen z.B. zwei
WORDs von einem Modbus Device in eine bestimmte Word-Order und Byte-Order
gebracht werden, um den echten Datentypen (z.B. 4-Byte Integer) zu erhalten,
kann dies in der `replace_io_file`-Datei definiert werden.
[Projekt-Dokumentation](https://revpimodio.org/doku2/#replace_io_file)

Der Pfad zu der Definitionsdatei wird in PiCtory über den MEM `Replace_IO_file`
vom "MQTT Client"-Module angegeben. Soll keine Definitionsdatei geladen
werden, lässt man das Eingabefeld einfach leer.

## Weitere Themen

- [Projektinformation](./data/README.md)
