// SPDX-FileCopyrightText: 2023-2025 KUNBUS GmbH
//
// SPDX-License-Identifier: GPL-2.0-or-later

import { Card, CardBody, CardTitle, Grid, GridItem } from "@patternfly/react-core";
import React from "react";
import cockpit from "cockpit";

import { DataProcessorIcon } from "@patternfly/react-icons";
import { UiDivider, InstallFeatureCard, UiCardTitle } from "../../common/ui-components.jsx";

const _ = cockpit.gettext;

export function RunTimeCard ({ getRevPiSwitch }) {
    const cardTitle = _("Runtimes");
    const packageName = ["revpipyload"];
    const featureName = "RevPiPyLoad";

    return (
        <Card isFullHeight name='runtime'>
            <CardTitle>
                <UiCardTitle>
                    <DataProcessorIcon style={{ marginRight: "1rem" }} />
                    {cardTitle}
                </UiCardTitle>
                <UiDivider />
            </CardTitle>
            <CardBody>
                <Grid hasGutter>
                    <GridItem span={12}>
                        <InstallFeatureCard packagesName={packageName} featureName={featureName}>
                            {getRevPiSwitch("revpipyload")}
                        </InstallFeatureCard>
                    </GridItem>
                </Grid>
            </CardBody>
        </Card>
    );
}
