#!/bin/bash

# SPDX-FileCopyrightText: 2023-2025 KUNBUS GmbH
#
# SPDX-License-Identifier: GPL-2.0-or-later

set -e

if [ "$EUID" -ne 0 ]; then
	echo "Script needs to run as root" >&2
	exit 1
fi

# Directory is created and managed by systemd-tempfiles (see ../systemd/cockpit-revpi-pictory-sso.tmpfiles.conf)
PICTORY_SSO_PATH=/run/cockpit-revpi-pictory-sso

# Generate a random token that will be used as one-time password to authorise user in pictory
SSO_TOKEN=$(uuid)
SSO_TOKEN_FILE="$PICTORY_SSO_PATH/$SSO_TOKEN"

# The user calling this script with superuser privileges is either set by sudo or pkexec
SSO_USER_ID=${SUDO_UID:-$PKEXEC_UID}

if [ -z "$SSO_USER_ID" ]; then
	echo "Could not determine user id. Both SUDO_UID and $PKEXEC_UID are not set" >&2
	exit 1
fi

SSO_USER_NAME=$(id -nu "$SSO_USER_ID")

echo "Creating SSO Token $SSO_TOKEN_FILE for user '$SSO_USER_NAME'" >&2

echo "$SSO_USER_NAME" >  "$SSO_TOKEN_FILE"

echo -n "$SSO_TOKEN"
