# Build process

During the build process described in your `rules` file, there is an important
detail to note:

While building each plugin, the `dist` folder is created for the plugin's output
but is subsequently cleared before building the next plugin. To ensure that the
build outputs of each plugin are preserved, the content of the `dist` folder is
saved after each plugin's compilation into a separate folder named
`distsave-<package-name>`. Here, `<package-name>` corresponds to the specific
name of the plugin.

The path to these saved build outputs, i.e., `distsave-<package-name>`, must
therefore be referenced in the `.install` files of the respective Debian
packages to ensure the built content is correctly included in the final
packages.

In summary:

1. During the build of each plugin, the `dist` folder is used but cleared
   afterward.
2. To avoid loss of data, the contents of `dist` are saved in
   `distsave-<package-name>` for each plugin.
3. The `.install` files must use this save path (`distsave-<package-name>`) to
   ensure the correct files are packaged.
